%define _name gst-rtsp-server
%define ver_major 1.20
%define gst_api_ver 1.0
%define api_ver 1.0

%def_disable doc
%def_enable introspection
%def_with tests_package
%{?_with_test_package:%def_enable examples}

Name: lib%_name
Version: %ver_major.7
Release: alt1

Summary: GStreamer-%api_ver RTSP server library
Group: System/Libraries
License: LGPLv2+
Url: https://gstreamer.freedesktop.org/modules/%_name-server.html

Source: https://gstreamer.freedesktop.org/src/%_name/%_name-%version.tar.xz

%define glib_ver 2.44.0
%define gst_ver %version

Requires: gst-plugins-base%api_ver >= %gst_ver gst-plugins-good%api_ver gst-plugins-bad%api_ver

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson glib2-devel >= %glib_ver
BuildRequires: gstreamer%api_ver-devel >= %gst_ver
BuildRequires: gst-plugins%api_ver-devel >= %gst_ver gst-plugins-good%api_ver gst-plugins-bad%api_ver-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel gst-plugins%api_ver-gir-devel}
BuildRequires: libcgroup-devel
%{?_enable_doc:BuildRequires: hotdoc gstreamer%api_ver-utils}

%description
A GStreamer-based RTSP server library.

%package devel
Summary: Development files for %_name
Group: Development/C
Requires: %name = %version-%release

%description devel
Development files for the GStreamer RTSP server library.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides developer documentation for %name.

%package gir
Summary: GObject introspection data for %_name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GStreamer RTSP server library.

%package gir-devel
Summary: GObject introspection devel data for %_name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the GStreamer RTSP server library.

%package tests
Summary: Tests programms from %name package
Group: System/Libraries
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the GStreamer-based RTSP server library.

%prep
%setup -n %_name-%version

%build

%meson \
	%{?_disable_introspection:-Dintrospection=disabled} \
	%{?_disable_doc:-Ddoc=disabled} \
	%{?_enable_examples:-Dexamples=enabled}
%nil
%meson_build

%install
%meson_install

%if_with tests_package
mkdir -p %buildroot%_bindir
pushd %{_target_platform}/examples
for f in test-* ; do
[ -f $f ] && install -pm755 $f %buildroot%_bindir/gst-rtsp-$f; done
popd
%endif

%files
%_libdir/libgstrtspserver-%api_ver.so.*
%_libdir/gstreamer-%gst_api_ver/libgstrtspclientsink.so
%doc README* TODO NEWS RELEASE

%files devel
%_includedir/gstreamer-%api_ver/gst/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled doc
%files devel-doc
%_datadir/gtk-doc/html/%_name-%api_ver/
%endif

%if_enabled introspection
%files gir
%_typelibdir/GstRtspServer-%api_ver.typelib

%files gir-devel
%_girdir/GstRtspServer-%api_ver.gir
%endif

%if_with tests_package
%files tests
%_bindir/*-test-*
%endif

%changelog
