%def_disable snapshot

%define _name gupnp-igd
%define ver_major 1.2
%define api_ver 1.0
%define gupnp_api_ver 1.2
%def_disable static
%def_enable gtk_doc
%def_enable introspection
%def_disable check

Name: lib%_name
Version: %ver_major.0
Release: alt1.2

Summary: A library to handle UPnP IGD port mapping
Group: System/Libraries
License: LGPL-2.1
Url: http://www.gupnp.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define gupnp_ver 1.2.1
%define glib_ver 2.38

BuildRequires(pre): meson rpm-build-gir
BuildRequires: libgupnp%gupnp_api_ver-devel >= %gupnp_ver
BuildRequires: glib2-devel >= %glib_ver
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgupnp%gupnp_api_ver-gir-devel}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}

%description
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%name is a library to handle UPnP IGD port mapping.

%package devel
Summary: Development files and libraries for gUPnP-IGD
Group: Development/C
Requires: %name = %EVR

%description devel
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%name is a library to handle UPnP IGD port mapping.
This package provides files for development with gUPnP-IGD.

%package devel-doc
Summary: Development documentaion for gUPnP-IGD
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%name is a library to handle UPnP IGD port mapping.
This package provides development documentations for gUPnP-IGD.

%package gir
Summary: GObject introspection data for the gUPnP-IGD library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the gUPnP-IGD library

%package gir-devel
Summary: GObject introspection devel data for the gUPnP-IGD library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the gUPnP-IGD library

%prep
%setup -n %_name-%version

%build
%meson \
	%{?_disable_introspection:-Dintrospection=false} \
	%{?_enable_gtk_doc:-Dgtk_doc=true}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%__meson_test -v -t 2

%files
%_libdir/*.so.*
%doc AUTHORS README NEWS

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%{?_enable_gtk_doc:%files devel-doc
%_datadir/gtk-doc/html/*}

%if_enabled introspection
%files gir
%_typelibdir/GUPnPIgd-%api_ver.typelib

%files gir-devel
%_girdir/GUPnPIgd-%api_ver.gir
%endif


%changelog
