%def_disable snapshot
%define api_ver 1.0

%def_disable python
%def_enable check

Name: libimobiledevice
Version: 1.3.0
Release: alt1

Summary: Library for connecting to Apple iPhone and iPod touch
Group: System/Libraries
License: GPL-2.0 and LGPL-2.1
Url: http://www.libimobiledevice.org

%if_disabled snapshot
Source: %url/downloads/%name-%version.tar.bz2
%else
# VCS: https://github.com/libimobiledevice/libimobiledevice.git
Source: %name-%version.tar
%endif

%define plist_ver 2.2.0
%define usbmuxd_ver 2.0.2
%define cython_ver 0.18

BuildPreReq: libplist-devel >= %plist_ver
BuildPreReq: libusbmuxd-devel >= %usbmuxd_ver

BuildRequires: gcc-c++ autoconf-archive glib2-devel libxml2-devel libusb-devel libplistmm-devel
BuildRequires: libgnutls-devel libtasn1-devel libgcrypt-devel libssl-devel
%{?_enable_python:BuildRequires: python3-devel python3-module-Cython >= %cython_ver python3-module-libplist}

%description
libimobiledevice is a library for connecting to Apple's iPhone or iPod touch devices

%package devel
Summary: Development package for libimobiledevice
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides files for development using libimobiledevice.

%package -n python-module-%name
Summary: Python bindings for libimobiledevice
Group: Development/Python
Requires: %name = %version-%release

%description -n python-module-%name
Python bindings for libimobiledevice.

%prep
%setup

%build
%autoreconf
%configure --disable-static \
	%{?_disable_python:--without-cython} \
	%{?_enable_python:PYTHON=%__python3}
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_bindir/idevice*
%_libdir/%name-%api_ver.so.*
%_man1dir/*
%doc AUTHORS NEWS README*

%files devel
%_includedir/%name
%_libdir/%name-%api_ver.so
%_pkgconfigdir/*.pc

%if_enabled python
%files -n python-module-%name
%python_sitelibdir/imobiledevice.so
%exclude %python_sitelibdir/imobiledevice.la
%endif

%changelog
