%def_disable snapshot
%define api_ver 1.0
%define sover 2
# disabled by default
%def_disable gtk_doc
%def_disable introspection
%def_disable check

Name: libinstpatch
Version: 1.1.6
Release: alt1.1

Summary: MIDI instrument patch library
Group: System/Libraries
License: LGPL-2.1-only
Url: https://www.swamiproject.org/

%if_disabled snapshot
Source: https://github.com/swami/%name/archive/v%version/%name-%version.tar.gz
%else
Vcs: https://github.com/swami/libinstpatch
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-macros-cmake
BuildRequires: astyle cmake libgio-devel libsndfile-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
%{?_enable_gtk_doc:BuildRequires: gtk-doc}
%{?_enable_check:BuildRequires: ctest}

%description
libInstPatch stands for lib-Instrument-Patch and is a library for processing
digital sample based MIDI instrument "patch" files. The types of files
libInstPatch supports are used for creating instrument sounds for wavetable
synthesis. libInstPatch provides an object framework (based on GObject) to load
patch files into, which can then be edited, converted, compressed and saved.

%package devel
Group: Development/C
Summary: Development package for %name
Requires: %name = %EVR

%description devel
This package includes the development libraries and header files for
%name.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake \
-DCMAKE_BUILD_TYPE="Release" \
%{?_enable_gtk_doc:-DGTKDOC_ENABLED=TRUE} \
%{?_enable_introspection:-DINTROSPECTION_ENABLED=TRUE}
%nil
%cmake_build

%install
%cmake_install

%check
%cmake_build -t test

%files
%_libdir/%name-%api_ver.so.*
%doc AUTHORS ChangeLog README.md COPYING

%files devel
%_includedir/%name-%sover/
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%name-%api_ver.pc
%doc examples/*.c

%changelog
