Name: libisoburn
Version: 1.5.4
Release: alt1

Summary: ISO9660 filesystem creation library
License: GPLv2
Group: System/Libraries

Url: http://libburnia-project.org
Source: %name-%version.tar

BuildRequires: zlib-devel libacl-devel libattr-devel libreadline-devel
BuildRequires: libburn-devel >= %version, libisofs-devel >= %version
BuildRequires: texinfo
# For tests
BuildRequires: gcc-c++

%description
libisoburn is a frontend for libraries libburn and libisofs
which enables creation and expansion of ISO-9660 filesystems
on all CD/DVD media supported by libburn. This includes media
like DVD+RW, which do not support multi-session management
on media level and even plain disk files or block devices.

The price for that is thorough specialization on data files
in ISO-9660 filesystem images. So libisoburn is not suitable
for audio (CD-DA) or any other CD layout which does not entirely
consist of ISO-9660 sessions.

Currently it is only supported on Linux with kernels >= 2.4.

%package devel
Summary: Development files for libisofs
Group: System/Libraries
Requires: %name = %version

%description devel
libisoburn is a frontend for libraries libburn and libisofs
which enables creation and expansion of ISO-9660 filesystems
on all CD/DVD media supported by libburn. This includes media
like DVD+RW, which do not support multi-session management
on media level and even plain disk files or block devices.

The price for that is thorough specialization on data files
in ISO-9660 filesystem images. So libisoburn is not suitable
for audio (CD-DA) or any other CD layout which does not entirely
consist of ISO-9660 sessions.

Currently it is only supported on Linux with kernels >= 2.4.

This package contains development headers.

%package -n xorriso
Summary: Creates an image of an ISO9660 filesystem
Group: Archiving/Cd burning
Requires: %name = %version
Requires: libburn >= %version

%description -n xorriso
xorriso is a program which maps file objects from POSIX compliant
filesystems into Rock Ridge enhanced ISO 9660 filesystems and
allows session-wise manipulation of such filesystems. It can load
the management information of existing ISO images and it writes
the session results to optical media or to filesystem objects.

Currently it is only supported on Linux with kernels >= 2.4.

A special property of xorriso is that it needs neither an external
ISO 9660 formatter program nor an external burn program for CD
or DVD but rather incorporates the libraries of libburnia-project.org .

%package -n xorriso-x11
Summary: Graphical utility to create ISO9660 image
Group: Archiving/Cd burning
Requires: xorriso = %version
BuildArch: noarch

%description -n xorriso-x11
This package contains GUI for xorriso, a program to create
or extract ISO9660 images common for CD-ROM/DVD media.

%prep
%setup
touch NEWS

%build
%autoreconf
%configure \
	--disable-static

%make_build

%install
%makeinstall_std

%check
# From Fedora
export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:%buildroot%_libdir"
export TERM="xterm"
cd releng
if ! ./run_all_auto -x ../xorriso/xorriso; then
	cat releng_generated_data/log.*
	exit 1
fi

%files
%_libdir/%name.so.*

%files devel
%dir %_includedir/%name
%_includedir/%name/*.h
%_libdir/%name.so
%_pkgconfigdir/*.pc

%files -n xorriso
%_man1dir/*
%_infodir/*
%_bindir/*
%exclude %_bindir/xorriso-tcltk

%files -n xorriso-x11
%_bindir/xorriso-tcltk

%changelog
