%add_optflags -fcommon

%define soversion 11

Name: libmirage
Version: 3.2.4
Release: alt2.1

Summary: A CD-ROM image access library
License: GPLv2+
Group: System/Libraries

URL: http://cdemu.sourceforge.net
Packager: Nazarov Denis <nenderus@altlinux.org>

# http://downloads.sourceforge.net/cdemu/%name-%version.tar.bz2
Source: %name-%version.tar

BuildPreReq: gobject-introspection-devel
BuildPreReq: libblkid-devel
BuildPreReq: libflac-devel
BuildPreReq: libmount-devel
BuildPreReq: libogg-devel
BuildPreReq: libopus-devel
BuildPreReq: libpcre-devel
BuildPreReq: libselinux-devel
BuildPreReq: libvorbis-devel

BuildRequires: bzlib-devel
BuildRequires: cmake
BuildRequires: glib-networking
BuildRequires: gtk-doc
BuildRequires: intltool
BuildRequires: libGConf
BuildRequires: liblzma-devel
BuildRequires: libsamplerate-devel
BuildRequires: libsndfile-devel
BuildRequires: zlib-devel

%description
This is libMirage library, a CD-ROM image access library, and part of the 
userspace-cdemu suite, a free, GPL CD/DVD-ROM device emulator for linux. It is
written in C and based on GLib.

The aim of libMirage is to provide uniform access to the data stored in 
different image formats, by creating a representation of disc stored in image 
file, which is based on GObjects.

%package -n %name%soversion
Summary: A CD-ROM image access library
Group: System/Libraries
Provides: %name = %version
Obsoletes: %name
Conflicts: %{name}10

%description -n %name%soversion
This is libMirage library, a CD-ROM image access library, and part of the 
userspace-cdemu suite, a free, GPL CD/DVD-ROM device emulator for linux. It is
written in C and based on GLib.

The aim of libMirage is to provide uniform access to the data stored in 
different image formats, by creating a representation of disc stored in image 
file, which is based on GObjects.

%package devel
Summary: A CD-ROM image access library
Group: Development/C
Requires: glib2-devel

%description devel
This is libMirage library, a CD-ROM image access library, and part of the 
userspace-cdemu suite, a free, GPL CD/DVD-ROM device emulator for linux. It is
written in C and based on GLib.

This package contains files needed to develop with libMirage.

%prep
%setup -q

%build
%cmake
%cmake_build

%install
%cmakeinstall_std
%find_lang %name

%files -n %name%soversion -f %name.lang
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%_libdir/libmirage.so.*
%dir %_libdir/libmirage-3.2
%_libdir/libmirage-3.2/*.so
%_datadir/mime/packages/*.xml

%files devel
%_libdir/libmirage.so
%_libdir/girepository-1.0/*
%_pkgconfigdir/%name.pc
%dir %_includedir/%name-3.2
%dir %_includedir/%name-3.2/mirage
%_includedir/%name-3.2/mirage/*.h
%_datadir/gir-1.0/*
%dir %_datadir/gtk-doc
%dir %_datadir/gtk-doc/html
%doc %_datadir/gtk-doc/html/%name

%changelog
