%define _unpackaged_files_terminate_build 1

%def_without openimageio

# TODO: build docs, build and run tests

%define oname opencolorio

Name:           lib%oname
Version:        1.1.1
Release:        alt5
Summary:        Enables color transforms and image display across graphics apps
Group:          System/Libraries

License:        BSD
URL:            https://opencolorio.org/

# https://github.com/imageworks/OpenColorIO.git
Source:         %name-%version.tar

# patches from Fedora

# Work with system libraries instead of bundled.

# Fix build against yaml-cpp 0.6.0+
# This patch is fine for our case (building against system yaml-cpp)
# but probably a bit too simple-minded to upstream as-is. See
# https://github.com/imageworks/OpenColorIO/issues/517
Patch1:         ocio-1.1.0-yamlcpp060.patch
Patch2:         ocio-glext_h.patch

Patch3:         ocio-1.1.1-upstream-typo-fix.patch

# Utilities
BuildRequires:  cmake gcc-c++
BuildRequires:  help2man

# WARNING: OpenColorIO and OpenImageIO are cross dependent.
# If an ABI incompatible update is done in one, the other also needs to be
# rebuilt.
%if_with openimageio
BuildRequires:  libopenimageio-devel
%endif
BuildRequires:  openexr-devel

# Libraries
BuildRequires:  libGL-devel libGLU-devel
BuildRequires:  libX11-devel libXmu-devel libXi-devel
BuildRequires:  libfreeglut-devel
BuildRequires:  libGLEW-devel
BuildRequires:  zlib-devel

#######################
# Unbundled libraries #
#######################
BuildRequires:  tinyxml-devel
BuildRequires:  liblcms2-devel
BuildRequires:  libyaml-cpp-devel
BuildRequires:  boost-devel

%add_findprov_skiplist %_pkgconfigdir/*.pc

%description
OCIO enables color transforms and image display to be handled in a consistent
manner across multiple graphics applications. Unlike other color management
solutions, OCIO is geared towards motion-picture post production, with an
emphasis on visual effects and animation color pipelines.


%package -n %oname-tools
Summary:        Command line tools for %name
Group:          Other
Requires:       %name = %EVR
Conflicts:      opencolorio2.0-tools

%description -n %oname-tools
Command line tools for %oname.


%package devel
Summary:        Development libraries and headers for %name
Group:          Development/Other
Requires:       %name = %EVR
Conflicts:      libopencolorio2.0-devel

%description devel
Development libraries and headers for %oname.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

# Remove bundled libraries
rm -f ext/lcms*
rm -f ext/tinyxml*
rm -f ext/yaml*

%ifarch %e2k
# lcc: Lut3DOp.cpp is too sloppy code for my -Werror!
sed -i 's, -Werror,,' src/core/CMakeLists.txt src/pyglue/CMakeLists.txt
%add_optflags -std=c++11
%endif

%build
%cmake_insource \
	-DOCIO_BUILD_STATIC=OFF \
	-DOCIO_BUILD_DOCS=OFF \
	-DOCIO_BUILD_PYGLUE=OFF \
	-DOCIO_BUILD_TESTS=OFF \
	-DUSE_EXTERNAL_YAML=TRUE \
	-DUSE_EXTERNAL_TINYXML=TRUE \
	-DUSE_EXTERNAL_LCMS=TRUE \
%ifnarch x86_64 %e2k
	-DOCIO_USE_SSE=OFF \
%endif
%ifnarch %e2k
	-DOpenGL_GL_PREFERENCE=GLVND \
%endif
	%nil

# LD_LIBRARY_PATH is needed for proper doc generation
LD_LIBRARY_PATH=$(pwd)/src/core %make_build

%install
LD_LIBRARY_PATH=$(pwd)/src/core %makeinstall_std

# Generate man pages
mkdir -p %buildroot%_man1dir

for i in %buildroot%_bindir/* ; do
	if [ "$(basename $i)" != "ociodisplay" ] ; then
		LD_LIBRARY_PATH=%buildroot%_libdir \
		help2man -N -s 1 --version-string=%version \
		-o %buildroot%_man1dir/$(basename $i).1 \
		$i
	fi
done

# Fix location of cmake files.
mkdir -p %buildroot%_datadir/cmake/Modules
find %buildroot -name "*.cmake" -exec mv {} %buildroot%_datadir/cmake/Modules/ \;

%files
%doc LICENSE
%doc ChangeLog README.md
%_libdir/*.so.*
%dir %_datadir/ocio
%_datadir/ocio/setup_ocio.sh

%files -n %oname-tools
%_bindir/*
%_man1dir/*

%files devel
%_datadir/cmake/Modules/*
%_includedir/OpenColorIO/
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
