%def_enable internal_absl

# Dynamic build is not supported by upstream
%def_enable static

%def_disable pipewire

Name: libowt-tg
Version: 4.3.0.11
Release: alt1

Summary: Open WebRTC Toolkit with Telegram desktop patches

License: Apache-2.0
Group: System/Libraries
Url: https://github.com/desktop-app/tg_owt

# Source-url: https://github.com/desktop-app/tg_owt/archive/master.zip
Source: %name-%version.tar

# Source1-url: https://github.com/cisco/libsrtp/archive/refs/tags/v2.5.0.tar.gz
Source1: %name-libsrtp-%version.tar

# Source2-url: https://github.com/abseil/abseil-cpp/archive/refs/tags/20230125.3.tar.gz
Source2: %name-abseil-cpp-%version.tar

Patch1: 0011-cmake-external.cmake-add-link_libyuv-function.patch
Patch2: 0012-cmake-libwebrtcbuild.cmake-add-tg_owt-libyuv-only-if.patch
Patch3: 0013-CMakeLists.txt-use-external-libyuv.patch
Patch4: 0014-CMakeLists.txt-don-t-include-cmake-rules-for-externa.patch

Patch2000: %name-e2k.patch

BuildRequires(pre): rpm-macros-cmake

BuildRequires: libalsa-devel
BuildRequires: libXtst-devel libXcomposite-devel libXdamage-devel libXrender-devel libXrandr-devel
BuildRequires: libavformat-devel libswresample-devel libswscale-devel
BuildRequires: libdb4-devel libjpeg-devel libopus-devel libpulseaudio-devel libssl-devel yasm
BuildRequires: libprotobuf-devel protobuf-compiler
BuildRequires: libgio-devel

%if_disabled internal_absl
BuildRequires: libabseil-cpp-devel >= 20211102.0
%endif
BuildRequires: libopenh264-devel
#BuildRequires: libusrsctp-devel
BuildRequires: libvpx-devel >= 1.10.0
%if_enabled pipewire
BuildRequires: pipewire-libs-devel
%endif
#BuildRequires: libsrtp2-devel >= 2.5.0
BuildRequires: libyuv-devel >= 0.0.1874
BuildRequires: libcrc32c-devel

# TODO remove epoxy
BuildRequires: libgbm-devel libdrm-devel libepoxy-devel

# Just disable noise (cmake TODO https://gitlab.kitware.com/cmake/cmake/-/issues/18158):
# Package 'libpcre', required by 'glib-2.0', not found
# Package libpcre was not found in the pkg-config search path.
BuildRequires: libpcre-devel
# Just to disable noise like Package 'libffi', required by 'gobject-2.0', not found
BuildRequires: libffi-devel

BuildRequires: gcc-c++ cmake ninja-build

# TODO: enable logging and debugging
#add_optflags -DRTC_DISABLE_LOGGING=1

%if_disabled static
%add_optflags -fPIC
%endif

#if_enabled static
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
#endif
%global optflags_lto -ffat-lto-objects
%add_optflags -ffat-lto-objects

# https://github.com/desktop-app/tg_owt/issues/106
# NDEBUG or DCHECK_ALWAYS_ON enable RTC_DCHECK_ON
%add_optflags -DNDEBUG

%ifarch %ix86
%add_optflags -msse2 -mfpmath=sse
# verify-elf: ERROR: ./usr/lib/libtg_owt.so.0.0.0: TEXTREL entry found: 0x0000000
%set_verify_elf_method textrel=relaxed
%endif

%description
Open WebRTC Toolkit with Telegram desktop patches.

WebRTC is an open source project that enables web browsers with Real-Time
Communications (RTC) capabilities via simple Javascript APIs. The WebRTC
components have been optimized to best serve this purpose.
WebRTC implements the W3C's proposal for video conferencing on the web.

%package devel
Summary: Open WebRTC Toolkit library and header files
Group: Development/C++
%if_disabled static
Requires: %name = %EVR
%endif
Requires: libjpeg-devel libopus-devel
Requires: libvpx-devel
Requires: libyuv-devel
#Requires: libsrtp2-devel


%description devel
%name-devel contains the libraries and header files needed to
develop programs which make use of %name.

%prep
%setup -a1 -a2
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p2
%ifarch %e2k
%patch2000 -p2
%endif

# TODO (used in cmake checks):
rm -rv src/third_party/openh264
rm -rv src/third_party/libyuv
rm -rv src/third_party/crc32c
rm -v cmake/libopenh264.cmake
rm -v cmake/libyuv.cmake
rm -v cmake/libcrc32c.cmake
rm -rfv src/base/android/

# stop using direct path lib libyuv headers (TODO: move to the libyuv patch?)
find -type f -name "*.cc" | xargs subst 's|third_party/libyuv/include/||'
# stop using embedded srtp2
#find -type f -name "*.h" | xargs subst 's|third_party/libsrtp/crypto/include/|srtp2/|'
#find -type f -name "*.h" | xargs subst 's|third_party/libsrtp/include/|srtp2/|'
#find -type f -name "*.cc" | xargs subst 's|third_party/libsrtp/include/|srtp2/|'

# not used, pulls in excessive deps
sed -i '/absl\/strings\/cord.cc/d' cmake/libabsl.cmake

%build
%cmake_insource \
          -DCMAKE_BUILD_TYPE=RelWithDebInfo \
          -DBUILD_SHARED_LIBS:BOOL=OFF \
          -DTG_OWT_PACKAGED_BUILD:BOOL=ON \
          -DCMAKE_POSITION_INDEPENDENT_CODE:BOOL=ON \
          -DTG_OWT_USE_PROTOBUF:BOOL=ON \
%if_enabled pipewire
          -DTG_OWT_USE_PIPEWIRE:BOOL=ON \
%else
          -DTG_OWT_USE_PIPEWIRE:BOOL=OFF \
%endif
          %nil
%make_build VERBOSE=1

%install
%makeinstall_std
rm -rv %buildroot%_includedir/tg_owt/sdk/{objc,android}/
rm -rv %buildroot%_includedir/tg_owt/modules/audio_device/android

%if_disabled internal_absl
rm -rv %buildroot%_includedir/tg_owt/third_party/abseil-cpp/
%endif

rm -rv %buildroot%_includedir/tg_owt/third_party/libvpx
rm -rv %buildroot%_includedir/tg_owt/third_party/{yasm,pffft,rnnoise}

%if_disabled static
%files
%_libdir/libtg_owt.so.*
%endif

%files devel
%_includedir/tg_owt/
%if_disabled static
%_libdir/libtg_owt.so
%else
%_libdir/libtg_owt.a
%endif
%_libdir/cmake/tg_owt/

%changelog
