%define _unpackaged_files_terminate_build 1
%define engines_dir $(pkg-config --variable=enginesdir --silence-errors libcrypto)

%def_with check

Name: libp11
Version: 0.4.11
Release: alt1

Summary: Library for using PKCS#11 modules
Group: System/Libraries
License: LGPLv2.1

Url: https://github.com/OpenSC/libp11/wiki
Source: %name-%version.tar
Patch: %name-%version-alt.patch

Provides: openssl-engine_pkcs11 = %version-%release
Obsoletes: openssl-engine_pkcs11 < %version-%release

BuildRequires: pkgconfig(p11-kit-1)
BuildRequires: libssl-devel >= 0.9.8
BuildRequires: doxygen xsltproc

%if_with check
BuildRequires: /proc
BuildRequires: openssl
BuildRequires: softhsm
BuildRequires: opensc
%endif

%description
Libp11 is a library implementing a small layer on top of PKCS#11 API
to make using PKCS#11 implementations easier.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release
Requires: libssl-devel

%description devel
Development files for %name.

%prep
%setup
%patch -p1
cat > README.ALT <<EOF
In ALTLinux, the engine file has been placed in the
%_libdir/openssl/engines directory instead of the default
%_libdir/engines. This was done so in order to match our openssl
installation.

Considering this new path, below is the suggested change to openssl.cnf
in order to use this engine:

openssl_conf = openssl_def

[openssl_def]
engines = engine_section

[engine_section]
pkcs11 = pkcs11_section

[pkcs11_section]
engine_id = pkcs11
dynamic_path = %engines_dir/pkcs11.so
MODULE_PATH = %_libdir/opensc-pkcs11.so
init = 0

EOF

chmod 0644 README.ALT

%build
%autoreconf
%configure \
        --disable-static \
        --enable-api-doc \
        --with-enginesdir=%engines_dir

%make_build

%install
%makeinstall_std

# Cleanup
rm %buildroot%_libdir/*.la
rm %buildroot%engines_dir/*.la
rm -r %buildroot%_docdir/%name

%check
%make check || { cat ./tests/test-suite.log; exit 1; }

%files
%doc COPYING NEWS README.md README.ALT
%_libdir/libp11.so.*
%_libdir/openssl/engines*/libpkcs11.so*
%_libdir/openssl/engines*/pkcs11.so*

%files devel
%_libdir/libp11.so
%_pkgconfigdir/libp11.pc
%_includedir/*

%changelog
