%def_disable snapshot

%define rname pangomm
%define ver_major 2.48
%define api_ver %ver_major

%def_enable docs
%def_enable check

Name: lib%rname%api_ver
Version: %ver_major.2
Release: alt1

Summary: This library provides a C++ interface to pango
License: LGPL-2.1 and GPL-2.0
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/

%if_enabled snapshot
Source: %rname-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%rname/%ver_major/%rname-%version.tar.xz
%endif

%define pango_ver 1.41.0
%define glibmm_api_ver 2.68
%define glibmm_ver 2.68.0
%define cairomm_api_ver 1.16
%define cairomm_ver 1.16.0

BuildRequires(pre): meson
BuildRequires: mm-common gcc-c++
BuildRequires: libcairomm%cairomm_api_ver-devel >= %cairomm_ver
BuildRequires: libglibmm%glibmm_api_ver-devel >= %glibmm_ver
BuildRequires: libpango-devel >= %pango_ver
%{?_enable_docs:BuildRequires: docbook-style-xsl doxygen graphviz xsltproc}

%description
This library provides a C++ interface to pango.

%package devel
Summary: Headers and development files of %rname library
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description devel
This package contains the headers and various development files needed
for compiling or development of applications that wants C++ interface
of %name library.

%package devel-doc
Summary: %rname documentation (html)
Group: Publishing
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
%rname development documentation (html)

%prep
%setup -n %rname-%version

%build
%{?_enable_snapshot:mm-common-prepare -f}
%meson \
    %{?_enable_docs:-Dbuild-documentation=true} \
    %{?_enable_snapshot:-Dmaintainer-mode=true
    -Dbuild-documentation=true}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%_includedir/%rname-%api_ver
%_libdir/*.so
%_libdir/%rname-%api_ver
%_pkgconfigdir/*.pc

%if_enabled docs
%files devel-doc
%_datadir/devhelp/books/%rname-%api_ver
%_docdir/%rname-%api_ver
%endif

%changelog
