Name: libpng15
Version: 1.5.30
Release: alt1

Summary: A library of functions for manipulating PNG image format files
License: zlib
Group: System/Legacy libraries
Url: http://www.libpng.org/pub/png/

# git://git.altlinux.org/gears/l/%name.git
Source: %name-%version-%release.tar

# Automatically added by buildreq on Tue Feb 08 2011
BuildRequires: zlib-devel

%package devel
Summary: PNG development library
Group: Development/C
Requires: libpng15 = %version-%release, zlib-devel
Conflicts: libpng12-devel
Conflicts: libpng-devel

%description
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package contains the runtime library files needed to run software
using libpng.

%description devel
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package contains the header and development files needed to build
programs and packages using libpng.

%prep
%setup -n %name-%version-%release

%build
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std
rm %buildroot%_libdir/lib*.la

%define docdir %_docdir/libpng-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -p -m644 CHANGES LICENSE README TODO example.c libpng*.txt \
	%buildroot%docdir/
xz -9 %buildroot%docdir/*.txt %buildroot%docdir/CHANGES

%filter_from_provides /^pkgconfig(libpng)/d

%check
%make_build -k check

%files
%_libdir/*.so.*
%dir %docdir
%docdir/[CLR]*

%files devel
%_bindir/*-config
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*
%docdir
%exclude %docdir/[CLR]*

%changelog
