%define _unpackaged_files_terminate_build 1

Name: libpst
Version: 0.6.76
Release: alt1
Summary: Tools for conversion of Outlook files to mailbox and other formats
License: %gpl2plus
Group: System/Libraries

Url: http://www.five-ten-sg.com/libpst
Source0: %url/packages/%name-%version.tar
Source100: libpst.watch
Patch1: %name-%version-alt-known-fields.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-python3
# Automatically added by buildreq on Tue Aug 04 2009
BuildRequires: ImageMagick-tools gcc-c++ libgd3-devel zlib-devel
BuildRequires: python3-devel boost-python3-devel
BuildRequires: libgsf-devel
BuildRequires: xmlto doxygen graphviz

%define pkgdocdir %_docdir/%name-%version

%description
libpst converts Outlook PST files to mailbox and others formats:
kmail, its own recursive format or separate each email into its own
file. It currently handles EMails, Folders and mostly Contacts.

This is a fork of the libpst project at SourceForge. Another fork is
located at http://alioth.debian.org/projects/libpst/

This version can now convert both 32 bit Outlook files (pre 2003), and
the 64 bit Outlook 2003 pst files. Utilities are supplied to convert
email messages to both mbox and MH mailbox formats, and to DII load file
format for use with many of the CT Summation products. Contacts can be
converted to a simple list, to vcard format, or to ldif format for
import to an LDAP server.

%package devel
Summary: Development files for libpst
Group: Development/C
Requires: %name = %EVR

%description devel
This package provides header and libraries for build programs
against libpst

%package tools
Summary: libpst tools
Group: File tools
Requires: %name = %EVR

%description tools
Tools to cope with PST (Outlook Personal Folders) files:
  readpst - convert to mbox and other formats
  lspst - list PST file data
  readpstlog - convert a readpst logfile to text format
  pst2ldif - extract contacts in .ldif format
  pst2dii - extract email messages into DII load format

%package docs
Summary: libpst documentation
Group: Documentation
Requires: %name = %EVR
BuildArch: noarch
# License for xml/MAPI_definitions.pdf is GFDL1.1 with no invariant sections etc.,
# therefore it must be GPL2-compatible. (In case that file is packaged.)

%description docs
Developer's documentation for libpst

%package -n python3-module-%name
Summary: Python interface to libpst (for reading Outlook files)
Group: Development/Python3

%description  -n python3-module-%name
Python interface to libpst (for reading Outlook files)

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure \
	--enable-libpst-shared \
	--disable-static \
	--with-boost-python=boost_python%{python_version_nodots python3} \
	%nil

%make_build

%install
%makeinstall_std

# Some reverse-engineered documentation:
mkdir -p %buildroot%pkgdocdir/format-documentation
install -m0644 xml/*.pdf -t %buildroot%pkgdocdir/format-documentation/

# remove unpackaged files
rm -f %buildroot%_libdir/python*/site-packages/*.la

%files
%_libdir/*.so.*
%dir %pkgdocdir
# LICENSE etc.
%pkgdocdir/[A-Z]*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*
%_man5dir/*

%files tools
%_bindir/*
%_man1dir/*

%files docs
%pkgdocdir/*
# LICENSE etc.
%exclude %pkgdocdir/[A-Z]*

%files -n python3-module-%name
%python3_sitelibdir/*.so

%changelog
