%define _name libqmi
%define _libexecdir %prefix/libexec

%def_enable introspection

Name: %_name-glib
Version: 1.32.4
Release: alt1

Summary: QMI modem protocol helper library
License: LGPLv2+
Group: System/Libraries
URL: https://gitlab.freedesktop.org/mobile-broadband/libqmi
Vcs: https://gitlab.freedesktop.org/mobile-broadband/libqmi.git
Source: %name-%version.tar
Patch: %_name-%version-%release.patch

BuildRequires(pre): meson

BuildRequires: glib2-devel libgio-devel
BuildRequires: libmbim-glib-devel >= 1.18.0
BuildRequires: libgudev-devel
BuildRequires: libqrtr-glib-devel
BuildRequires: python3
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libqrtr-glib-gir-devel}
BuildRequires: gtk-doc help2man bash-completion

%define _unpackaged_files_terminate_build 1

%description
libqmi is a glib-based library for talking to WWAN modems and devices
which speak the Qualcomm MSM Interface (QMI) protocol.

%package utils
Summary: QMI command line utilities
License: GPLv2+
Group: System/Base
Requires: %name = %version-%release

%description utils
QMI command line utilities

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: glib2-devel

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
%summary

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
%summary

%package devel-doc
Summary: This package contains development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Requires: %name-devel = %version-%release

%description devel-doc
This package contains development documentation for %name

%prep
%setup
%patch -p1
touch README ChangeLog

%build
%meson \
	-Dmbim_qmux=true \
	-Dfirmware_update=true \
	-Dudev=true \
	-Dqrtr=true \
%if_enabled introspection
    -Dintrospection=true \
%else
    -Dintrospection=false \
%endif
    -Dgtk_doc=true

%meson_build -v

%install
%meson_install

%check
%meson_test

%files
%doc NEWS README.md AUTHORS
%_libdir/*.so.*
%_libexecdir/qmi-proxy

%files utils
%_bindir/*
%_man1dir/qmi*.1*
%_datadir/bash-completion/completions/*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/*.typelib

%files gir-devel
%_datadir/gir-1.0/*.gir
%endif

%files devel-doc
%_datadir/gtk-doc/html/*

%changelog
