%define _unpackaged_files_terminate_build 1
%def_with zfs

Name: libraft
Version: 0.17.1
Release: alt1

Summary: Fully asynchronous C implementation of the Raft consensus protocol.
License: Apache-2.0
Group: Development/C

Url: https://github.com/canonical/raft
Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires: pkgconfig(libuv) >= 1.18.0
BuildRequires: pkgconfig(liblz4) >= 1.7.1
BuildRequires: btrfs-progs xfsprogs
%{?_with_zfs:BuildRequires: zfs-utils}

%description
Fully asynchronous C implementation of the Raft consensus protocol.
The library has modular design: its core part implements only the core Raft
algorithm logic, in a fully platform independent way. On top of that, a
pluggable interface defines the I/O implementation for networking (send/receive
RPC messages) and disk persistence (store log entries and snapshots).

%package devel
Summary: Fully asynchronous C implementation of the Raft consensus protocol (development files)
Group: Development/C
Requires: %name = %version-%release

%description devel
Fully asynchronous C implementation of the Raft consensus protocol.
The library has modular design: its core part implements only the core Raft
algorithm logic, in a fully platform independent way. On top of that, a
pluggable interface defines the I/O implementation for networking (send/receive
RPC messages) and disk persistence (store log entries and snapshots).

%prep
%setup
%patch -p1

%build
%autoreconf
%configure --disable-static --disable-fixture
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS README.md LICENSE
%_libdir/%name.so.*

%files devel
%_includedir/raft.h
%_includedir/raft/
%_libdir/%name.so
%_pkgconfigdir/raft.pc

%changelog
