%def_disable snapshot
%def_disable static
%{?_enable_static:%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}}

%define _name LibRaw
%define ver_major 0.20
%define sover 20
# demosaic pack version
%define dmp_ver 0.18.8

Name: libraw
Version: %ver_major.2
Release: alt1.1

Summary: library for reading RAW files obtained from digital photo cameras
Group: System/Libraries
License: LGPLv2.1 and CDDL-1.0
Url: http://www.libraw.org

%if_disabled snapshot
#Source: %url/data/%_name-%version.tar.gz
Source: https://github.com/LibRaw/LibRaw/archive/%version/%_name-%version.tar.gz
%else
Vcs: https://github.com/LibRaw/LibRaw.git
Source: %_name-%version.tar
%endif
# GPLv2, GPLv3
Source1: %url/data/%_name-demosaic-pack-GPL2-%dmp_ver.tar.gz
Source2: %url/data/%_name-demosaic-pack-GPL3-%dmp_ver.tar.gz

BuildRequires: gcc-c++ libjasper-devel liblcms2-devel libjpeg-devel libgomp-devel

%description
LibRaw is a library for reading RAW files from digital photo cameras
(CRW/CR2, NEF, RAF, DNG, MOS, KDC, DCR, etc.; virtually all RAW formats
are supported). It pays special attention to correct retrieval of data
required for subsequent RAW conversion.
This package contains shared library.

%package samples
Group: Graphics
Summary: sample tools based on the libraw
Requires: %name = %version-%release

%description samples
LibRaw is a library for reading RAW files from digital photo cameras
(CRW/CR2, NEF, RAF, DNG, MOS, KDC, DCR, etc.; virtually all RAW formats
are supported). It pays special attention to correct retrieval of data
required for subsequent RAW conversion.
This package contains samples binaries.

%package devel
Group: Development/C
Summary: library for reading RAW files
Requires: %name = %version-%release

%description devel
LibRaw is a library for reading RAW files from digital photo cameras
(CRW/CR2, NEF, RAF, DNG, MOS, KDC, DCR, etc.; virtually all RAW formats
are supported). It pays special attention to correct retrieval of data
required for subsequent RAW conversion.
This package contains library headers.

%package devel-static
Group: Development/C
Summary: static library for reading RAW files
Requires: %name-devel = %version-%release

%description devel-static
LibRaw is a library for reading RAW files from digital photo cameras
(CRW/CR2, NEF, RAF, DNG, MOS, KDC, DCR, etc.; virtually all RAW formats
are supported). It pays special attention to correct retrieval of data
required for subsequent RAW conversion.
This package contains static library.

%prep
%setup -n %_name-%version -a1 -a2

%build
%ifarch %e2k
# lcc 1.23.20 doesn't link a shared library against -lomp
# explicitly even if -fopenmp is there
export LIBS+="-lpthread -lomp"
%endif
%autoreconf
%configure \
    %{subst_enable static} \
    --docdir=%_datadir/doc/libraw-%version \
    --enable-jasper \
    --enable-lcms \
    --enable-jpeg \
    --enable-openmp
%nil
%make_build

%install
%makeinstall_std

%check
%make check

%files
%_libdir/libraw.so.*
%_libdir/libraw_r.so.*
%_datadir/doc/libraw-%version

%files samples
%_bindir/*

%files devel
%_includedir/libraw
%_libdir/libraw.so
%_libdir/libraw_r.so
%_pkgconfigdir/libraw.pc
%_pkgconfigdir/libraw_r.pc

%if_enabled static
%files devel-static
%_libdir/libraw.a
%_libdir/libraw_r.a
%endif

%changelog
