# ./rdf_init_internal.h:142: error: expected specifier-qualifier-list before 'rasqal_world'

# Conditional build:
%def_without	threestore	# with 3store
%define oname redland
%ifndef _gtkdocdir
%define _gtkdocdir %_datadir/gtk-doc/html/
%endif

Name: libredland
Version: 1.0.17
Release: alt3

Summary: Redland - a library that provides a high-level interface for RDF

License: LGPL v2.1+ or GPL v2+ or Apache v2
Group: System/Libraries
Url: http://librdf.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://download.librdf.org/source/%oname-%version.tar.bz2
Patch: %oname-link.patch
Patch1: %oname-sqlite.patch
Patch2: %oname-mysql8.patch

# Automatically added by buildreq on Thu Sep 01 2011 (-bi)
# optimized out: elfutils libpq-devel pkg-config raptor2-devel
#BuildRequires: glibc-devel-static gtk-doc libdb4-devel libiodbc-devel libltdl7-devel libmysqlclient-devel libredland-devel libsqlite-devel libsqlite3-devel postgresql-devel rasqal-devel
BuildRequires: glibc-devel gtk-doc libdb4-devel libiodbc-devel libltdl-devel glib2-devel
BuildRequires: libmysqlclient-devel libsqlite3-devel postgresql-devel rasqal-devel
BuildRequires: libssl-devel zlib-devel

%if_with threestore
BuildRequires: 3store-devel >= 2.0
BuildRequires: 3store-devel < 3.0
%endif

%description
Redland is a library that provides a high-level interface for RDF
allowing the RDF graph to be parsed from XML, stored, queried and
manipulated. Redland implements each of the RDF concepts in its own
class via an object based API, reflected into the other language APIs:
Perl, Python, Tcl, Java and Ruby. Some of the classes providing the
parsers, storage mechanisms and other elements are built as modules
that can be added or removed as required.

%package devel
Summary: Headers for Redland RDF library
Group: Development/C
Requires: %name = %version-%release
%if_with threestore
Requires: 3store-devel >= 2.0
Requires: 3store-devel < 3.0
%endif

%description devel
Headers for Redland RDF library.

%package -n python-module-redland
Summary: Python bindings for Redland RDF library
Group: System/Libraries/Python
Requires: %name = %version-%release

%description -n python-module-redland
Python bindings for Redland RDF library

%prep
%setup -n %oname-%version
%patch2 -p2

#autoreconf
NOCONFIGURE=1 ./autogen.sh

%build
%configure \
	--disable-static \
	--enable-release \
	--with-html-dir=%_gtkdocdir \
	--with-threestore=%{!?with_threestore:no}%{?with_threestore:yes} \
	--with-raptor=system \
	--with-rasqal=system

%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog* FAQS.html LICENSE.html NEWS.html README.html RELEASE.html TODO.html
%_bindir/rdfproc
%_bindir/redland-db-upgrade
%_libdir/librdf.so.*
%dir %_libdir/redland/
%_libdir/redland/librdf_storage_mysql.so
%_libdir/redland/librdf_storage_postgresql.so
%_libdir/redland/librdf_storage_sqlite.so
%_libdir/redland/librdf_storage_virtuoso.so
%dir %_datadir/redland/
%_datadir/redland/mysql-v*.ttl
%_man1dir/rdfproc.1*
%_man1dir/redland-db-upgrade.1*


%files devel
%doc docs/{README.html,storage.html}
%_bindir/redland-config
%_libdir/librdf.so
%_includedir/librdf.h
%_includedir/rdf_*.h
%_includedir/redland.h
%_datadir/redland/Redland.i
%_pkgconfigdir/redland.pc
%_man1dir/redland-config.1*
%_man3dir/redland.3*
%_gtkdocdir/redland/

%changelog
