%def_disable bootstrap

%define bname librsvg
%define ver_major 2.56
%define api_ver 2.0
%define gtk_api_ver 2.0
%define gtk3_api_ver 3.0

%define _libexecdir %_prefix/libexec

%def_disable static
%def_enable gtk_doc
%def_enable man
%def_enable pixbuf_loader
%def_enable introspection
%def_enable vala
%def_disable installed_tests
%def_disable check

Name: %bname
Version: %ver_major.3
Release: alt1
Epoch: 1

Summary: SVG rendering library
License: LGPL-2.1
Group: System/Libraries
Url: https://wiki.gnome.org/action/show/Projects/LibRsvg

Source: ftp://ftp.gnome.org/pub/gnome/sources/%bname/%ver_major/%bname-%version.tar.xz
# since 2.55 no longer contains vendored Rust dependencies
%{?_disable_bootstrap:Source1: %name-%version-cargo.tar}

# From configure.ac
# since 2.53.1 rust-1.56 required
%define rust_ver 1.65
%define glib_ver 2.52.0
%define pango_ver 1.46
%define gtk3_ver 3.10.0
%define libxml2_ver 2.9.0
%define cairo_ver 1.16
%define vala_ver 0.18
%define freetype_ver 2.9
%define harfbuzz_ver 2.0.0

BuildRequires: /proc rust >= %rust_ver rust-cargo
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libgtk+3-devel >= %gtk3_ver
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libcairo-devel >= %cairo_ver
BuildRequires: libfreetype-devel >= %freetype_ver
BuildRequires: libharfbuzz-devel >= %harfbuzz_ver
BuildRequires: libX11-devel libXt-devel zlib-devel
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_man:BuildRequires: python3-module-docutils}
%{?_enable_introspection:
BuildRequires(pre): rpm-build-gir
BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel}
%{?_enable_vala:
BuildRequires(pre): rpm-build-vala
BuildRequires: vala-tools >= %vala_ver}
%{?_enable_check:BuildRequires: libgtest-devel}

%description
A high performance SVG rendering library associated with the Gnome Project.

%package devel
Summary: Libraries and include files for developing with librsvg
Group: Development/C
Requires: %bname = %EVR

%description devel
This package provides the necessary development libraries and include
files to allow you to develop with librsvg.

%package devel-doc
Summary: Development documentation for %bname
Group: Development/Documentation
BuildArch: noarch
Conflicts: %bname < %EVR

%description devel-doc
%bname is a SVG library based on libart.
This package contains development documentation for %bname

%package devel-static
Summary: Static libraries for developing with librsvg
Group: Development/C
Requires: %name-devel = %EVR

%description devel-static
This package provides the necessary static libraries files to allow you
to build static software with librsvg.

%package utils
Summary: Utilities to manipulate SVG files
Group: Graphics
Requires: %bname = %EVR

%description utils
This package contains small utilities to manipulate SVG files found in
%bname package.

%package -n libgtk-engine-svg
Summary: A GTK+ engine for graphical themes that use SVG images.
Group: Graphical desktop/GNOME
Requires: %bname = %EVR

%description -n libgtk-engine-svg
This package contains a GTK+2 engine that renders graphical themes with SVG
images in them.

%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the %name library

%package gir-devel
Summary: GObject introspection devel data for the %name library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %EVR
Requires: %name-devel = %EVR

%description gir-devel
GObject introspection devel data for the %name library

%package tests
Summary: Tests for %name
Group: Development/Other
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed %name.

%prep
%setup -n %bname-%version %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version-cargo.tar .cargo/ vendor/}

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
	%{subst_enable static} \
	%{?_enable_introspection:--enable-introspection=yes} \
	%{?_disable_gtk_doc:--disable-gtk-doc} \
	%{?_enable_pixbuf_loader:--enable-pixbuf-loader} \
	%{?_enable_vala:--enable-vala=yes} \
	%{?_enable_installed_tests:--enable-installed-tests} \
	--docdir=%_datadir/doc/%name
%nil
%make_build

%install
%makeinstall_std
%find_lang %name

%check
%make -k check VERBOSE=1

%files -f %name.lang
%_libdir/*.so.*
%{?_enable_pixbuf_loader:%_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.so}
%_datadir/thumbnailers/librsvg.thumbnailer
%doc AUTHORS NEWS* README*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/%bname-%gtk_api_ver.pc
%{?_enable_vala:%_vapidir/%name-%api_ver.vapi}

%if_enabled gtk_doc
%files devel-doc
%_datadir/doc/Rsvg-%api_ver
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%{?_enable_pixbuf_loader:%_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.a}
%endif

%files utils
%_bindir/*
%{?_enable_man:%_man1dir/*}

%if_enabled introspection
%files gir
%_typelibdir/Rsvg-%api_ver.typelib

%files gir-devel
%_girdir/Rsvg-%api_ver.gir
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/RSVG/
%_datadir/installed-tests/RSVG/
%endif

%{?_enable_pixbuf_loader:%exclude %_libdir/gdk-pixbuf-%gtk_api_ver/*/loaders/*.la}

%changelog
