%def_enable snapshot
%def_enable check

Name: libsndfile
Version: 1.1.0
Release: alt1

Summary: A library to handle various audio file formats
Group: System/Libraries
License: LGPL-2.1
Url: https://libsndfile.github.io/libsndfile
Packager: Valery Inozemtsev <shrek@altlinux.ru>

%if_disabled snapshot
Source: https://github.com/libsndfile/libsndfile/releases/download/%version/%name-%version.tar.xz
%else
Vcs: https://github.com/libsndfile/libsndfile.git
Source: %name-%version.tar
%endif
Patch0: libsndfile-1.1.0+-fc-system-gsm.patch

BuildRequires: gcc-c++ autogen python3
BuildRequires: libalsa-devel libflac-devel libsqlite3-devel
BuildRequires: libogg-devel libvorbis-devel libgsm-devel
BuildRequires: libmpg123-devel liblame-devel
BuildRequires: libopus-devel

%description
%name is a C library for reading and writing sound files such as
AIFF, AU and WAV files through one standard interface. It can currently
read/write 8, 16, 24 and 32-bit PCM files as well as 32-bit floating
point WAV files and a number of compressed formats.

This package contains shared library required for %name-based applications.

%package devel
Summary: Development environment for %name
Group: Development/C
Requires: %name = %EVR
Requires: libflac-devel libogg-devel libvorbis-devel
Requires: libopus-devel libmpg123-devel libgsm-devel
Requires: liblame-devel

%description devel
This package contains development files required
in development of the %name-based applications.

%package utils
Summary: Utilities for %name
Group: Sound
Requires: %name = %EVR

%description utils
This package contains utilities for %name

%prep
%setup
%patch0 -p1 -b .system-gsm
rm -r src/GSM610

%build
%autoreconf
%configure
%make_build

%install
%make DESTDIR=%buildroot \
      docdir=%_docdir/%name-devel-%version/html install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%make -k check VERBOSE=1

%files
%_libdir/%name.so.*
%doc AUTHORS NEWS* CHANGELOG* README

%files devel
%_includedir/*
%_libdir/%name.so
%_pkgconfigdir/sndfile.pc
%doc %_docdir/%name-devel-%version

%files utils
%_bindir/sndfile-cmp
%_bindir/sndfile-concat
%_bindir/sndfile-convert
%_bindir/sndfile-deinterleave
%_bindir/sndfile-info
%_bindir/sndfile-interleave
%_bindir/sndfile-metadata-get
%_bindir/sndfile-metadata-set
%_bindir/sndfile-play
%_bindir/sndfile-salvage
%_man1dir/*.1*

%changelog
