%define _unpackaged_files_terminate_build 1

Name: libssh2
Version: 1.11.0
Release: alt2

Summary: A library implementing the SSH2 protocol
Group: Networking/Remote access
License: BSD
Url: https://www.libssh2.org/
VCS: https://github.com/libssh2/libssh2.git 
Source: %name-%version.tar
Patch0001: 0001-scp-fix-missing-cast-for-targets-without-large-file-support.patch
Patch0002: 0002-autotools-skip-tests-requiring-static-lib-if---disable-static-1072.patch
Patch0003: 0003-autotools-improve-libz-position.patch
Patch0004: 0004-test_sshdtest-set-a-safe-PID-directory-1089.patch
Patch0005: 0005-Dont-put-LIBS-in-pc-file.patch
Patch0006: 0006-upstream-CVE-2023-48795-fix.patch

BuildRequires: libssl-devel zlib-devel
# for tests
BuildRequires: /proc /dev/pts openssh-server /usr/bin/man

%description
libssh2 is a library implementing the SSH2 protocol as defined by
Internet Drafts: SECSH-TRANS(22), SECSH-USERAUTH(25),
SECSH-CONNECTION(23), SECSH-ARCH(20), SECSH-FILEXFER(06)*,
SECSH-DHGEX(04), and SECSH-NUMBERS(10).

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package docs
Summary: Documentation for %name
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description docs
This package contains manual pages and examples for
developing applications that use %name.

%prep
%setup
%autopatch -p1

%build
# set version
./maketgz %version only
%autoreconf
%configure --disable-static --enable-shared --disable-docker-tests
%make_build

%install
%makeinstall_std

%check
echo "PrintLastLog no" >> tests/openssh_server/sshd_config
echo "UsePAM no" >> tests/openssh_server/sshd_config
echo "StrictModes no" >> tests/openssh_server/sshd_config
LC_ALL=en_US.UTF-8 %make -C tests check

%files
%doc docs/AUTHORS README RELEASE-NOTES COPYING
%_libdir/*.so.*

%files docs
%doc docs/BINDINGS.md docs/HACKING.md docs/TODO
%_man3dir/*.3*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
