%define _unpackaged_files_terminate_build 1

%define cholmod_ver 3.0.14
%define umfpack_ver 5.7.9

%define _cmake__builddir BUILD

Name: libsuitesparse
Version: 5.8.1
Release: alt5

Summary: Shared libraries for sparse matrix calculations
License: LGPL and GPL
Group: Sciences/Mathematics
Url: http://faculty.cse.tamu.edu/davis/suitesparse.html

Source: SuiteSparse-%version.tar
Source1: cholmod.pc
Source2: umfpack.pc

Patch1: SuiteSparse-%version-alt.patch
Patch2000: %name-e2k.patch

BuildRequires: libmetis-devel gcc-c++ libtbb-devel
BuildRequires: libblas-devel
BuildRequires: libgmp-devel
BuildRequires: libmpfr-devel

# Automatically added by buildreq on Sun Sep 14 2008
BuildRequires: gcc-fortran liblapack-devel texlive-latex-base
BuildRequires: libgomp-devel
BuildRequires: cmake

%package devel
Summary: Development files of SuiteSparse
Group: Development/Other
Requires: %name = %EVR
Conflicts: libumfpack-devel UFconfig

%package devel-static
Summary: Static libraries of SuiteSparse
Group: Development/Other
Requires: %name-devel = %EVR
Conflicts: %name-devel < %EVR

%package devel-doc
Summary: Documentation for %name
Group: Sciences/Mathematics
BuildArch: noarch

%package examples
Summary: Examples for %name
Group: Sciences/Mathematics
BuildArch: noarch

%package tools
Summary: %name tools
Group: Sciences/Mathematics
Requires: %name = %EVR

%description
Package contains a set of shared libraries to use efficient calculation
algorithms with sparse matricies.

%description devel
Package contains a set of development files to use efficient calculation
algorithms with sparse matricies in your programs.

%description devel-static
Package contains a set of static libraries to use efficient calculation
algorithms with sparse matricies in your programs.

%description devel-doc
Documentation for a set of static libraries that provide an efficient
calculation algorithms with sparse matricies for your programs.

%description examples
Examples for SuiteSparse.

%description tools
Package contains Mongoose executable.
Mongoose executable can read a Matrix Market file containing an adjacency
matrix and output timing and partitioning information to a plain-text file.
Simply call it with the following syntax:
mongoose <MM-input-file.mtx> [output-file]

%prep
%setup
install -m644 %SOURCE1 %SOURCE2 .
%patch1 -p1
%ifarch %e2k
%patch2000 -p1
# -fopenmp must also be set when linking
sed -i '/CF += $(CFOPENMP)/a LDFLAGS += $(CFOPENMP)' \
	SuiteSparse_config/SuiteSparse_config.mk
%endif

# Copy examples src
mkdir demos-src/
cp -rpf --parents $(find ./ -name Demo) demos-src/

%build
sed -i "s|@VERSION@|%cholmod_ver|" cholmod.pc
sed -i "s|@VERSION@|%umfpack_ver|" umfpack.pc

%ifnarch %e2k
# Remove rpath due to "RPATH contains illegal entry" error
sed -i 's/ -Wl,-rpath=$(INSTALL_LIB)//' SuiteSparse_config/SuiteSparse_config.mk
%endif
pushd GraphBLAS
%cmake -DCMAKE_INSTALL_LIBDIR=%_libdir -DCMAKE_INSTALL_INCLUDEDIR=%_includedir
popd
pushd Mongoose
%cmake -DCMAKE_INSTALL_BINDIR=%_bindir -DCMAKE_INSTALL_LIBDIR=%_libdir -DCMAKE_INSTALL_INCLUDEDIR=%_includedir
popd
pushd metis-5.1.0
export GKLIB_PATH=$(pwd)/GKlib
%cmake -DGKLIB_PATH=${GKLIB_PATH}
popd

export JOBS=%__nprocs
%make -C SuiteSparse_config MY_METIS_LIB=-lmetis MY_METIS_INC=%_includedir/metis
%make -C CCOLAMD MY_METIS_LIB=-lmetis MY_METIS_INC=%_includedir/metis
%make TOPDIR=$PWD LD_LIBRARY_PATH=%_builddir/%name-%version/lib MY_METIS_LIB=-lmetis MY_METIS_INC=%_includedir/metis
%make docs MY_METIS_LIB=-lmetis MY_METIS_INC=%_includedir/metis

%install
install -d %buildroot%_libdir
install -d %buildroot%_includedir/suitesparse

%makeinstall_std MY_METIS_LIB=-lmetis MY_METIS_INC=%_includedir/metis INSTALL=%buildroot%_exec_prefix INSTALL_LIB=%buildroot%_libdir INSTALL_DOC=%buildroot%_docdir/%name-%version INSTALL_INCLUDE=%buildroot%_includedir/suitesparse

# Remove unnecessary static libraries
rm -f %buildroot%_libdir/*.a

install -p -m644 CXSparse/Include/cs.h \
	%buildroot%_includedir/suitesparse/cx_cs.h
install -d %buildroot%_pkgconfigdir
install -m644 *.pc %buildroot%_pkgconfigdir

pushd demos-src/
for i in $(find ./ -name Demo); do
	rm -f $(find $i -name '*.m')
	wcl=$(ls $i |wc -l)
	if [ "$wcl" != "0" ]; then
		install -d %buildroot%_datadir/%name/demos/$i
		cp -fR $i/* %buildroot%_datadir/%name/demos/$i/
	fi
done
popd

install -d %buildroot%_docdir/%name-%version/ChangeLogs
for i in BTF CAMD AMD CCOLAMD CHOLMOD COLAMD CSparse CXSparse KLU LDL \
	RBio SPQR UMFPACK
do
	install -p -m644 $i/Doc/ChangeLog \
		%buildroot%_docdir/%name-%version/ChangeLogs/ChangeLog.$i
done

pushd UMFPACK/Doc
for i in *.pdf; do
	mv $i UMFPACK_$i
done
popd
install -d %buildroot%_docdir/%name-%version/pdf
for i in AMD CAMD CHOLMOD KLU LDL SPQR UMFPACK
do
	install -p -m644 $i/Doc/*.pdf %buildroot%_docdir/%name-%version/pdf
done

mv %buildroot%_docdir/%name-%version/*.pdf %buildroot%_docdir/%name-%version/pdf/

%files
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*

%files devel-doc
%_docdir/%name-%version

%files examples
%_datadir/%name/demos/

%files tools
%_bindir/mongoose

%changelog
