%define oldname sx

Name:       libsx
Version:    2.17
Release:    alt2

Summary:    Tool to extract reports and run plug-ins against those extracted reports
License:    GPLv2
Group:      System/Libraries
URL:        http://fedorahosted.org/sx

BuildArch:  noarch

Source0:    https://git.fedorahosted.org/cgit/sx.git/snapshot/%{oldname}-%{version}.tar.gz
Source44:   import.info

BuildRequires(pre): rpm-build-python3
BuildRequires: python-tools-2to3

Provides: sx = %{version}-%{release}


%description
sxconsole is a tool used to extract various report types and then
analyze those extracted reports with plug-ins. The tool also provides
an archiving structure so that all the compressed and extracted
reports are saved to a directory. This tool was developed for
sysreport/sosreports but has been expanded to include any report that
has a class defined.

%prep
%setup -n %oldname-%version -q

sed -i 's|wb|w|' lib/%oldname/__init__.py

find -type f \( -name '*.py' -o -name 'sxconsole' \) \
                            -exec 2to3 -w -n '{}' +

%build
%__python3 setup.py build

%install
rm -rf ${RPM_BUILD_ROOT}
%__python3 setup.py install --optimize 1 --root=${RPM_BUILD_ROOT}

%files
%doc LICENSE AUTHORS PKG-INFO CHANGELOG
%doc doc/*
%_bindir/sxconsole
%python3_sitelibdir_noarch/*


%changelog
