%define rname taglib

Name: libtag
Version: 1.12
Release: alt1

Summary: TagLib, is well, a library for reading and editing audio meta data
License: LGPL / MPL
Group: System/Libraries
Url: http://taglib.github.io/
Packager: Sergey V Turchin <zerg@altlinux.org>

Provides: %rname = %version-%release

Source0: %rname-%version.tar
Source2: version-script.libtag

# SuSE
Patch2: taglib-1.8-ds-rusxmms-r2.patch
# ALT
Patch10: taglib-1.8-alt-versioning.patch

BuildRequires: gcc-c++ zlib-devel
#BuildRequires: librcc-devel
BuildRequires: doxygen graphviz cmake kde-common-devel

%description
TagLib, is well, a library for reading and editing audio meta data,
commonly know as tags.
Some goals of TagLib:
	A clean, high level, C++ API to handling audio meta data.
	Support for at least ID3v1, ID3v2 and Ogg Vorbis comments.
	A generic, simple API for the most common tagging related functions.
	Binary compatibility between minor releases using the standard KDE/Qt
	techniques for C++ binary compatibility.
	Make the tagging framework extensible by library users; i.e. it will be
	possible for libarary users to implement additional ID3v2 frames,
	without modifying the TagLib source.
Because TagLib desires to be toolkit agnostic, in hope of being widely
adopted and the most flexible in licensing TagLib provides many of its
own toolkit classes; in fact the only external dependancy that TagLib has,
it a semi-sane STL implementation.

%package devel
Group: Development/C
Summary: Headers and static lib for taglib development
Requires: %name = %version-%release
Provides: %rname-devel = %version-%release

%description devel
Install this package if you want do compile applications using the libtag
library.


%prep
%setup -q -n %rname-%version
install -m0644 %SOURCE2 ./
#%patch2 -p1
%patch10 -p1


%build
%Kcmake \
    -DINCLUDE_INSTALL_DIR=%_includedir \
    -DWITH_ASF:BOOL=ON \
    -DWITH_MP4:BOOL=ON \
    -DBUILD_EXAMPLES:BOOL=OFF \
    -DBUILD_TESTS:BOOL=OFF \
    -DBUILD_SHARED_LIBS:BOOL=ON \
    #
%Kmake
%Kmake docs

%install
%Kinstall

%files
%doc AUTHORS NEWS
%_libdir/libtag.so.1
%_libdir/libtag.so.1.*
%_libdir/libtag_c.so.0
%_libdir/libtag_c.so.0.*

%files devel
%doc BUILD-*/doc/html AUTHORS NEWS
%_bindir/taglib-config
%_libdir/libtag.so
%_libdir/libtag_c.so
%_libdir/pkgconfig/taglib*.pc
%dir %_includedir/taglib/
%_includedir/taglib/*.h
%_includedir/taglib/*.tcc

%changelog
