%def_without jbig

Name: libtiff
Version: 4.4.0
Release: alt8

Summary: Library of functions for manipulating TIFF format image files
License: libtiff
Group: System/Libraries
Url: https://libtiff.gitlab.io/libtiff/
VCS: https://gitlab.com/libtiff/libtiff.git

# git://git.altlinux.org/gears/l/%name
Source: %name-%version-%release.tar
Patch0: libtiff-4.4.0-fedora-cve-2024-7006.patch
Patch1: libtiff-4.4.0-upstream-cve-2023-52356.patch
Patch2: libtiff-4.4.0-upstream-cve-2023-6228.patch
Patch3: libtiff-4.4.0-upstream-cve-2022-40090.patch
Patch4: libtiff-4.4.0-debian-cve-2023-0795-0796-0797-0798-0799.patch
Patch5: libtiff-4.4.0-debian-cve-2023-0800-0801-0802-0803-0804.patch
Patch6: libtiff-4.4.0-upstream-cve-2023-1916.patch
Patch7: libtiff-4.4.0-ubuntu-cve-2023-25433.patch
Patch8: libtiff-4.4.0-upstream-cve-2023-26966.patch
Patch9: libtiff-4.4.0-upstream-cve-2023-2731.patch
Patch10: libtiff-4.4.0-upstream-cve-2023-2908.patch
Patch11: libtiff-4.4.0-upstream-cve-2023-3316.patch
Patch12: libtiff-4.4.0-upstream-cve-2023-3576.patch
Patch13: libtiff-4.4.0-upstream-cve-2023-3618.patch
Patch14: libtiff-4.4.0-upstream-cve-2023-41175.patch
Patch15: libtiff-4.4.0-ubuntu-cve-2023-6277-1.patch
Patch16: libtiff-4.4.0-ubuntu-cve-2023-6277-2.patch
Patch17: libtiff-4.4.0-ubuntu-cve-2023-6277-3.patch
Patch18: libtiff-4.4.0-ubuntu-cve-2023-6277-4.patch
Patch19: libtiff-4.4.0-debian-cve-2022-48281.patch
Patch20: libtiff-4.4.0-ubuntu-cve-2023-40745.patch
Patch21: libtiff-4.4.0-ubuntu-cve-2023-26965.patch
Patch22: libtiff-4.4.0-upstream-cve-2025-8176.patch
Patch23: libtiff-4.4.0-upstream-cve-2025-8177.patch
Patch24: libtiff-4.4.0-upstream-cve-2025-8534.patch
Patch25: libtiff-4.4.0-upstream-cve-2024-13978.patch
Patch26: libtiff-4.4.0-upstream-cve-2025-8851.patch
Patch27: libtiff-4.4.0-upstream-cve-2025-9165.patch
Patch28: libtiff-4.4.0-upstream-cve-2025-8961.patch

%def_disable static
%def_enable cxx

BuildRequires: gcc-c++ libSM-devel libXi-devel libXmu-devel libfreeglut-devel libjpeg-devel liblzma-devel libwebp-devel libzstd-devel zlib-devel

%if_with jbig
BuildRequires: libjbig-devel
%else
BuildConflicts: libjbig-devel
%endif

%description
This package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

%package -n libtiff5
Summary: Library of functions for manipulating TIFF format image files
Group: System/Libraries

%package utils
Summary: Programs for manipulating TIFF format image files
Group: Graphics
Requires: libtiff5 = %version-%release

%package -n tiffgt
Summary: Program for viewing TIFF format image files
Group: Graphics
Requires: libtiff5 = %version-%release

%package devel
Summary: Development files for programs which will use the tiff library
Group: Development/C
Requires: libtiff5 = %version-%release
Provides: libtiff5-devel
Obsoletes: libtiff5-devel

%package devel-static
Summary: Static tiff library
Group: Development/C
Requires: %name-devel = %version-%release

%package -n libtiffxx5
Summary: TIFF I/O C++ shared library
Group: System/Libraries
Requires: libtiff5 = %version-%release

%package -n libtiffxx-devel
Summary: TIFF I/O C++ development library and header files
Group: Development/C
Requires: libtiffxx5 = %version-%release

%description -n libtiff5
This package contains a library of functions for manipulating
TIFF (Tagged Image File Format) image format files.  TIFF is a widely
used file format for bitmapped images.  TIFF files usually end in the
.tif extension and they are often quite large.

%description utils
This package contains simple client programs for accessing
the tiff functions.

%description -n tiffgt
This package contains tiffgt - a TIFF file display program.

%description devel
This package contains the header files for developing programs which
will manipulate TIFF format image files using the tiff library.

%description devel-static
This package contains static %name library.

%description -n libtiffxx5
This package contains TIFF I/O C++ shared library

%description -n libtiffxx-devel
This package contains TIFF I/O C++ development library and header files.

%prep
%setup -n %name-%version-%release
%autopatch -p1
:>port/dummy.c

cd libtiff
cat > libtiff.sym << EOF
TIFFFaxBlackCodes
TIFFFaxBlackTable
TIFFFaxMainTable
TIFFFaxWhiteCodes
TIFFFaxWhiteTable
_TIFFCheckMalloc
_TIFFFax3fillruns
_TIFFMultiply32
_TIFFRewriteField
_TIFFGetExifFields
_TIFFClampDoubleToFloat
_TIFFFillStriles
TIFFFlushData1
_TIFFGetFields
_TIFFMergeFields
_TIFFSeekOK
_TIFFClampDoubleToUInt32
TIFFSetCompressionScheme
_TIFFgetMode
display_sRGB
EOF
sed -n 's/^extern[^)]\+[[:space:]]\*\?\([^[:space:]*()]\+\)[[:space:]]*(.*/\1/p' \
	tiffio.h >> libtiff.sym
sort -u -o libtiff.sym{,}
cat > libtiff.map << EOF
{
 global:
$(sed 's/.*/  &;/' libtiff.sym)
 local:
  *;
};
EOF
rm libtiff.sym

%build
%autoreconf
%define docdir %_docdir/%name-%version
%configure --with-docdir=%docdir --enable-ld-version-script \
	%{subst_enable static} %{subst_enable cxx}
%make_build X_PRE_LIBS= GLUT_CFLAGS= GLUT_CFLAGS= GLUT_LIBS='-lglut -lGL' \
	GLU_CFLAGS= GLU_LIBS= GL_CFLAGS= GL_LIBS=

%install
%makeinstall_std
xz -9 %buildroot%docdir/ChangeLog

%check
%make_build -k check

%files -n libtiff5
%_libdir/%name.so.?*
%dir %docdir
%docdir/[A-Z]*

%files utils
%_bindir/*
%_man1dir/*.*
%exclude %_bindir/tiffgt
%exclude %_man1dir/tiffgt.*

%files -n tiffgt
%_bindir/tiffgt
%_man1dir/tiffgt.*

%files devel
%_pkgconfigdir/*.pc
%_libdir/%name.so
%_includedir/*.h
%_man3dir/*.*
%dir %docdir
%docdir/html

%if_enabled static
%files devel-static
%_libdir/%name.a
%endif

%if_enabled cxx
%files -n libtiffxx5
%_libdir/libtiffxx.so.*

%files -n libtiffxx-devel
%_libdir/libtiffxx.so
%_includedir/*.hxx
%endif

%changelog
