%def_disable snapshot

%define _name totem-pl-parser
%define ver_major 3.26
%define api_ver 1.0
%define _libexecdir %_prefix/libexec

%def_enable gtk_doc
%def_enable introspection
%def_enable libgcrypt

Name: lib%_name
Version: %ver_major.6
Release: alt1

Summary: Shared libraries of the Totem media player play list parser
Group: System/Libraries
License: LGPL-2.0
Url: http://www.hadess.net/%_name.php3

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define glib_ver 2.56
%define archive_ver 3.0

BuildRequires(pre): meson
BuildRequires: gtk-doc libgio-devel >= %glib_ver
BuildRequires: libarchive-devel >= %archive_ver
BuildRequires: libgcrypt-devel libxml2-devel
BuildRequires: libuchardet-devel
%{?_enable_libgcrypt:BuildRequires: libgcrypt-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.9.5}

%description
Shared libraries that come with the Totem media player.

%package devel
Summary: Development files for Totem media player play list parser
Group: Development/C
Requires: %name = %version-%release

%description devel
Totem is simple movie player for the Gnome desktop based on Xine.
This package provides files needed to build applications using Totem
libraries.

%package devel-doc
Summary: Development documentation for Totem media player play list parser
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
Totem is simple movie player for the Gnome desktop based on Xine.
This package contains documentation needed to develop applications using Totem
libraries.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Totem playlist parser library

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Totem playlist parser library

%prep
%setup -n %_name-%version

%build
%meson \
    %{?_enable_gtk_doc:-Denable-gtk-doc=true} \
    %{?_enable_libgcrypt:-Denable-libgcrypt=yes}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %_name %_name-2.0

%files -f %name.lang
%_libdir/*.so.*
%doc AUTHORS NEWS README*

%files -n %name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n %name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/TotemPlParser-%api_ver.typelib

%files gir-devel
%_girdir/TotemPlParser-%api_ver.gir
%endif

%changelog
