%def_enable drm
%def_enable glx
%def_enable egl
%def_enable x11
%def_enable wayland

Name: libva1
Version: 1.8.3
Release: alt5

Summary: Video Acceleration (VA) API for Linux
License: MIT
Group: System/Libraries
Url: https://github.com/01org/libva

Source: %name-%version.tar
Patch: %name-%version-alt.patch

%if_enabled drm
BuildRequires: libdrm-devel
%endif
%if_enabled glx
BuildRequires: libGL-devel
%endif
%if_enabled egl
BuildRequires: libEGL-devel
%endif
%if_enabled x11
BuildRequires: libXext-devel libXfixes-devel
%endif
%if_enabled wayland
BuildRequires: libwayland-client-devel libwayland-server-devel
%endif
BuildRequires: gcc-c++
BuildRequires(pre): rpm-build-ubt

%description
Video Acceleration (VA) API for Linux - runtime
The libva library implements the Video Acceleration (VA) API for Linux.
The library loads a hardware dependendent driver.

Note also that VAAPI intel driver now resides in own package:
libva-driver-intel

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	%{subst_enable drm} \
	%{subst_enable glx} \
	%{subst_enable egl} \
	%{subst_enable x11} \
	%{subst_enable wayland} \
	--disable-static
%make_build

%install
%makeinstall_std

%files
%_libdir/*.so.*

%changelog
