%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec
%add_verify_elf_skiplist %_libexecdir/WebKitPluginProcess
%define api_ver 3.0
%define gtk_ver 3.0

%define oname webkit
%define _name webkitgtk

# none/opengl/cairo/clutter
%define acceleration_backend opengl
%def_enable introspection
%def_enable geolocation
%def_enable web_audio
%def_enable spellcheck
%def_disable webkit2

%define smp %__nprocs

Name: libwebkitgtk3
Version: 2.4.11
Release: alt12

Summary: Web browser engine
Group: System/Libraries
License: LGPL-2.0+ and BSD-3-Clause

Url: http://www.webkitgtk.org

Source: %url/releases/%_name-%version.tar.xz
Patch1: webkitgtk-2.4.0-alt-link.patch
Patch2: webkitgtk-2.4.9-fc-abs.patch
# https://bugs.webkit.org/show_bug.cgi?id=171612
Patch3: webkitgtk-2.4.11-icu59.patch
# https://bugs.webkit.org/show_bug.cgi?id=126985
Patch4: webkitgtk-x86-assembler-fix.patch
Patch5: webkitgtk-2.4.10-suse-aarch64.patch
Patch6: webkitgtk-2.4.11-icu65.patch
Patch7: webkitgtk-2.4.11-alt-bison-3.7-workaround.patch
Patch8: webkitgtk-2.4.11-icu69.patch

Obsoletes: %name-webinspector
Provides: %name-webinspector = %EVR

Requires: libjavascriptcoregtk3 = %version-%release

BuildRequires(pre): rpm-build-gir
BuildRequires: gcc-c++ libicu-devel bison perl-Switch zlib-devel
BuildRequires: chrpath
BuildRequires: flex >= 2.5.33
BuildRequires: gperf libjpeg-devel libpng-devel libwebp-devel
BuildRequires: libxml2-devel >= 2.6
BuildRequires: libXt-devel
BuildRequires: libgtk+3-devel >= 3.4.0
BuildRequires: libgail3-devel >= 3.0
BuildRequires: libenchant-devel >= 0.22
BuildRequires: libsqlite3-devel >= 3.0
BuildRequires: libxslt-devel >= 1.1.7
BuildRequires: gstreamer1.0-devel >= 1.0.3 gst-plugins1.0-devel >= 1.0.3
BuildRequires: librsvg-devel >= 2.2.0
BuildRequires: gtk-doc >= 1.10
BuildRequires: libsoup-devel >= 2.40.0
BuildRequires: libsecret-devel
BuildRequires: libpango-devel >= 1.21.0 libcairo-devel >= 1.10 libcairo-gobject-devel
BuildRequires: fontconfig-devel >= 2.4 libfreetype-devel libharfbuzz-devel
BuildRequires: libgio-devel >= 2.25.0
BuildRequires: python-modules-json
BuildRequires: ruby ruby-stdlibs
BuildRequires: python2-base

%if %acceleration_backend == opengl
BuildRequires: libGL-devel libXcomposite-devel libXdamage-devel
%endif

%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.9.5 libgtk+3-gir-devel libsoup-gir-devel}
%{?_enable_geolocation:BuildPreReq: geoclue2-devel}
%{?_enable_spellcheck:BuildPreReq: libenchant-devel}
%{?_enable_webkit2:BuildPreReq: libat-spi2-core-devel >= 2.2.1  libgtk+2-devel libgail-devel}

# for check
BuildRequires: xvfb-run python-module-pygobject3

%description
WebKit is an open source web browser engine.
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux.

%package devel
Summary: Development files for WebKit GTK+ port
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Requires: libjavascriptcoregtk3-devel = %version-%release

%description devel
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux. This package contains development headers.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version-%release

%description devel-doc
The GTK+ port of WebKit is intended to provide a browser component
primarily for users of the portable GTK+ UI toolkit on platforms like
Linux.

This package provides development documentation for %name.

%package -n libjavascriptcoregtk3
Summary: GTK+3 version of the JavaScriptCore engine
Group: System/Libraries

%description -n libjavascriptcoregtk3
This package provides GTK+3 version of the JavaScriptCore engine from
WebKit package.

%package -n libjavascriptcoregtk3-devel
Summary: Development files for JavaScriptCore library
Group: Development/GNOME and GTK+
Requires: libjavascriptcoregtk3 = %version-%release

%description -n libjavascriptcoregtk3-devel
This package provides development files for GTK+3 version of the
JavaScriptCore engine.

%package -n libwebkit2gtk
Summary: WebKit2 is a new API layer for WebKit
Group: System/Libraries
Requires: libjavascriptcoregtk3 = %version-%release

%description -n libwebkit2gtk
WebKit2 is a new API layer for WebKit designed from the ground up to support a split process model,
where the web content (JavaScript, HTML, layout, etc) lives in a separate process from the application UI.
This model is very similar to what Google Chrome offers, with the major difference being
that we have built the process split model directly into the framework, allowing other clients of WebKit to use it.

%package -n libwebkit2gtk-devel
Summary: WebKit2 is a new API layer for WebKit
Group: Development/GNOME and GTK+
Requires: libwebkitgtk3-devel = %version-%release
Requires: libjavascriptcoregtk3-devel = %version-%release
Requires: libwebkit2gtk = %version-%release

%description -n libwebkit2gtk-devel
WebKit2 is a new API layer for WebKit designed from the ground up to support a split process model,
where the web content (JavaScript, HTML, layout, etc) lives in a separate process from the application UI.
This model is very similar to what Google Chrome offers, with the major difference being
that we have built the process split model directly into the framework, allowing other clients of WebKit to use it.


%package jsc
Summary: JavaScriptCore shell for WebKit GTK+
Group: Development/GNOME and GTK+
Requires: libjavascriptcoregtk3 = %version-%release

%description jsc
jsc is a shell for JavaScriptCore, WebKit's JavaScript engine. It
allows you to interact with the JavaScript engine directly.

%package gir
Summary: GObject introspection data for the WebkitGTK library
Group: System/Libraries
Requires: %name = %version-%release
Requires: libjavascriptcoregtk3 = %version-%release
Requires: libjavascriptcoregtk3-gir  = %version-%release

%description gir
GObject introspection data for the WebkitGTK library

%package gir-devel
Summary: GObject introspection devel data for the WebkitGTK library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: libjavascriptcoregtk3-gir = %version-%release
Requires: libjavascriptcoregtk3-devel = %version-%release
Requires: libjavascriptcoregtk3-gir-devel = %version-%release

%description gir-devel
GObject introspection devel data for the WebkitGTK library

%package -n libjavascriptcoregtk3-gir
Summary: GObject introspection data for the JavaScriptCore library
Group: System/Libraries
Requires: libjavascriptcoregtk3 = %version-%release

%description -n libjavascriptcoregtk3-gir
GObject introspection data for the JavaScriptCore library

%package -n libjavascriptcoregtk3-gir-devel
Summary: GObject introspection devel data for the JavaScriptCore library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: libjavascriptcoregtk3-gir = %version-%release
Requires: libjavascriptcoregtk3-devel = %version-%release

%description -n libjavascriptcoregtk3-gir-devel
GObject introspection devel data for the JavaScriptCore library

%package -n libwebkit2gtk-gir
Summary: GObject introspection data for the Webkit2 library
Group: System/Libraries
Requires: libwebkit2gtk = %version-%release

%description -n libwebkit2gtk-gir
GObject introspection data for the Webkit2 library

%package -n libwebkit2gtk-gir-devel
Summary: GObject introspection data for the Webkit2 library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: libwebkit2gtk-gir = %version-%release
Requires: libwebkit2gtk-devel = %version-%release

%description -n libwebkit2gtk-gir-devel
GObject introspection data for the Webkit2 library

%prep
%setup -n %_name-%version
%patch1
%patch2 -p1
%patch3
%patch4 -p2
%patch5 -p1
%patch6 -p2
%patch7 -p1
%patch8 -p2

# fix build translations
%__subst 's|^all-local:|all-local: stamp-po|' GNUmakefile.am
rm -f Source/autotools/{compile,config.guess,config.sub,depcomp,install-sh,ltmain.sh,missing,libtool.m4,ltoptions.m4,ltsugar.m4,ltversion.m4,lt~obsolete.m4,gsettings.m4,gtk-doc.m4}

# fix python shebang
subst 's|#!/usr/bin/env python|#!%__python|' `fgrep -Rl '#!/usr/bin/env python' *`

%build
%add_optflags -Wno-expansion-to-defined -Wno-implicit-fallthrough
# Use linker flags to reduce memory consumption
%add_optflags -Wl,--no-keep-memory -Wl,--reduce-memory-overheads
# Add flags to prevent delete null pointer checks
%add_optflags -fno-delete-null-pointer-checks
%ifarch ppc ppc64 ppc64le riscv64
%add_optflags -DENABLE_YARR_JIT=0
%endif
# Fix build with gcc10
%add_optflags -DGLIB_VERSION_MIN_REQUIRED=GLIB_VERSION_2_36

# Build with -g1 on all platforms to avoid running into 4 GB ar format limit
# https://bugs.webkit.org/show_bug.cgi?id=91154
%define optflags_debug -g1

echo "GTK_DOC_CHECK([1.10])" >> configure.ac
gtkdocize --copy
%autoreconf -I Source/autotools
export PYTHON=%__python
%configure \
%ifarch ppc ppc64 ppc64le riscv64 mipsel
	--disable-jit \
%endif
%ifarch riscv64
	--enable-fast-malloc \
%endif
	--enable-video \
	--with-acceleration-backend=%acceleration_backend \
	--enable-webgl \
	%{subst_enable introspection} \
	%{subst_enable geolocation} \
	%{?_enable_web_audio:--enable-web-audio} \
	%{subst_enable webkit2} \
	--with-gtk=%gtk_ver

mkdir -p DerivedSources/webkit
mkdir -p DerivedSources/ANGLE
mkdir -p DerivedSources/WebKit2/webkit2gtk/webkit2
mkdir -p DerivedSources/InjectedBundle
mkdir -p DerivedSources/webkitdom
mkdir -p DerivedSources/Platform
mkdir -p Programs/resources

n=%smp
[  "$n"  -lt  16  ]  ||  n=16
%make -j $n

%install
%makeinstall_std
%find_lang WebKitGTK-3.0

mkdir -p %buildroot%_libexecdir/%_name
install -m755 Programs/GtkLauncher %buildroot%_libexecdir/%_name/
chrpath --delete %buildroot%_libexecdir/%_name/GtkLauncher
%if_enabled webkit2
install -m755 Programs/MiniBrowser %buildroot%_libexecdir/%_name/
chrpath --delete %buildroot%_libexecdir/%_name/MiniBrowser
%endif

%files -f WebKitGTK-3.0.lang
%_libdir/libwebkitgtk-%api_ver.so.*
%_libexecdir/%_name/GtkLauncher
%dir %_datadir/webkitgtk-%api_ver
%_datadir/webkitgtk-%api_ver/images
%_datadir/webkitgtk-%api_ver/resources

%files devel
%_libdir/libwebkitgtk-%api_ver.so
%dir %_includedir/webkitgtk-%api_ver
%_includedir/webkitgtk-%api_ver/webkit
%_includedir/webkitgtk-%api_ver/webkitdom
%_pkgconfigdir/webkitgtk-%api_ver.pc

%files devel-doc
%_gtk_docdir/*

%files -n libjavascriptcoregtk3
%_libdir/libjavascriptcoregtk-%api_ver.so.*

%files -n libjavascriptcoregtk3-devel
%_includedir/webkitgtk-%api_ver/JavaScriptCore
%_libdir/libjavascriptcoregtk-%api_ver.so
%_pkgconfigdir/javascriptcoregtk-%api_ver.pc

%if_enabled webkit2
%files -n libwebkit2gtk
%_libdir/libwebkit2gtk-%api_ver.so.*
%_libexecdir/WebKitPluginProcess
%_libexecdir/WebKitWebProcess
%_libexecdir/WebKitNetworkProcess
%_libexecdir/%_name/MiniBrowser
%_libdir/webkit2gtk-%api_ver

%files -n libwebkit2gtk-devel
%_libdir/libwebkit2gtk-%api_ver.so
%_includedir/webkitgtk-%api_ver/webkit2
%_pkgconfigdir/webkit2gtk-%api_ver.pc
%_pkgconfigdir/webkit2gtk-web-extension-%api_ver.pc

%if_enabled introspection
%files -n libwebkit2gtk-gir
%_typelibdir/WebKit2-%api_ver.typelib
%_typelibdir/WebKit2WebExtension-%api_ver.typelib

%files -n libwebkit2gtk-gir-devel
%_girdir/WebKit2-%api_ver.gir
%_girdir/WebKit2WebExtension-%api_ver.gir
%endif
%endif

%files jsc
%_bindir/jsc*

%if_enabled introspection
%files gir
%_typelibdir/WebKit-%api_ver.typelib

%files gir-devel
%_girdir/WebKit-%api_ver.gir

%files -n libjavascriptcoregtk3-gir
%_typelibdir/JavaScriptCore-%api_ver.typelib

%files -n libjavascriptcoregtk3-gir-devel
%_girdir/JavaScriptCore-%api_ver.gir
%endif


%changelog
