%define _name libwebp

%def_enable libwebpmux
%def_enable libwebpdemux
%def_enable libwebpdecoder
%define soversion 6

Name: %_name%soversion
Version: 0.5.2
Release: alt2

Summary: Library for the WebP graphics format
License: BSD
Group: System/Libraries

URL: http://webmproject.org/
Source: http://downloads.webmproject.org/releases/webp/%_name-%version.tar.gz

BuildRequires: libjpeg-devel libpng-devel libtiff-devel libgif-devel
BuildRequires: libfreeglut-devel

%description
WebP is an image format that does lossy compression of digital
photographic images. WebP consists of a codec based on VP8, and a
container based on RIFF. Webmasters, web developers and browser
developers can use WebP to compress, archive and distribute digital
images more efficiently.

%prep
%setup -n %_name-%version

%build
%autoreconf
%configure --disable-static \
	%{subst_enable libwebpmux} \
	%{subst_enable libwebpdemux} \
	%{subst_enable libwebpdecoder}
%make_build

%install
%makeinstall_std

%files
%_libdir/%_name.so.*
%{?_enable_libwebpmux:%_libdir/%{_name}mux.so.*}
#%{?_enable_libwebpdemux:%_libdir/%{_name}demux.so.*}
%{?_enable_libwebpdecoder:%_libdir/%{_name}decoder.so.*}

%changelog
