Name: libwebsockets
Version: 4.2.0
Release: alt2

Summary: A lightweight C library for Websockets

# base64-decode.c and ssl-http2.c is under MIT license with FPC exception.
# sha1-hollerbach is under BSD
# https://fedorahosted.org/fpc/ticket/546
# Test suite is licensed as Public domain (CC-zero)
License: LGPLv2 and Public Domain and BSD and MIT and zlib
Group: Development/C
Url: http://libwebsockets.org

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/warmcat/libwebsockets/archive/v%version.tar.gz#/%name-%version.tar.gz
Source: %name-%version.tar

# Automatically added by buildreq on Tue Jun 29 2021
# optimized out: cmake-modules libsasl2-3 libssl-devel libstdc++-devel pkg-config python-modules python2-base python3 python3-base python3-module-paste ruby ruby-stdlibs sh4
BuildRequires: cmake cvs gcc-c++ gem-did-you-mean git-core libcap-devel libssl-devel-static openssl python3-dev python3-module-mpl_toolkits subversion valgrind

BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libssl-devel
BuildRequires: zlib-devel
BuildRequires: libev-devel
BuildRequires: libcap-devel

# https://fedoraproject.org/wiki/Bundled_Libraries
Provides: bundled(sha1-hollerbach)
Provides: bundled(base64-decode)
Provides: bundled(ssl-http2)

%description
This is the libwebsockets C library for lightweight websocket clients and
servers.

%package devel
Group: Development/C
Summary: Headers for developing programs that will use %name
Requires: %name = %EVR

%description devel
This package contains the header files needed for developing
%name applications.

%package tests
Group: Development/C
Summary: Tests to use with %name
Requires: %name = %EVR

%description tests
This package contains the tests for %name applications.

%prep
%setup

%build
%cmake \
    -DLWS_LINK_TESTAPPS_DYNAMIC=ON \
    -DLWS_USE_LIBEV=OFF \
    -DLWS_WITHOUT_BUILTIN_GETIFADDRS=ON \
    -DLWS_USE_BUNDLED_ZLIB=OFF \
    -DLWS_WITHOUT_BUILTIN_SHA1=ON \
%ifarch %e2k
    -DDISABLE_WERROR=ON \
%endif
    -DLWS_WITH_STATIC=OFF
%cmake_build

%install
%cmakeinstall_std
find %buildroot -name '*.la' -exec rm -f {} ';'
find %buildroot -name '*.a' -exec rm -f {} ';'
find %buildroot -name '*.cmake' -exec rm -f {} ';'
find %buildroot -name '*_static.pc' -exec rm -f {} ';'

%files
%doc README.md changelog
%doc LICENSE
%_libdir/%name.so.*

%files devel
%doc READMEs/README.coding.md READMEs/ changelog
%doc LICENSE
%_includedir/%name.h
%_includedir/lws_config.h
%_includedir/%name
%_libdir/%name.so
%_pkgconfigdir/%name.pc

%files tests
%doc READMEs/README.coding.md READMEs/README.test-apps.md
%doc LICENSE
%_bindir/%name-test-*
%_datadir/%name-test-server/

%changelog
