# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define _libexecdir %_prefix/libexec

Name: lmms
Version: 1.2.2
Release: alt2.1

Summary: Linux MultiMedia Studio
License: GPL-2.0-or-later
Group: Sound

Url: http://lmms.sourceforge.net
# https://github.com/LMMS/lmms.git
Source: %name-%version.tar
Source4: %name-16x16.png
Source5: %name-32x32.png
Source6: %name-48x48.png
Patch1: %name-1.2.0-no_werror.patch
Patch2: %name-1.2.0-vst-nowine.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: rpm-build-lmms libfltk-devel 
BuildRequires: gcc-c++ cmake

BuildRequires: desktop-file-utils
BuildRequires: libfluidsynth-devel
%ifnarch %e2k riscv64
BuildRequires: libsoundio-devel
%endif
BuildRequires: qt5-base-devel
BuildRequires: liblame-devel
BuildRequires: qt5-tools-devel
BuildRequires: libstk-devel
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5Test)
BuildRequires: pkgconfig(Qt5UiTools)
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(fftw3f) >= 3.0.0
BuildRequires: pkgconfig(fluidsynth) >= 1.0.7
BuildRequires: pkgconfig(jack) >= 0.77
BuildRequires: pkgconfig(libpulse)
BuildRequires: pkgconfig(ogg)
BuildRequires: pkgconfig(portaudio-2.0)
BuildRequires: pkgconfig(samplerate) >= 0.1.8
BuildRequires: pkgconfig(sdl)
BuildRequires: pkgconfig(shared-mime-info)
BuildRequires: pkgconfig(sndfile) >= 1.0.11
BuildRequires: pkgconfig(vorbis)
BuildRequires: pkgconfig(vorbisenc)
BuildRequires: pkgconfig(vorbisfile)
BuildRequires: pkgconfig(xcb-keysyms)
BuildRequires: pkgconfig(xcb-util)
BuildRequires: pkgconfig(zlib)

%add_verify_elf_skiplist %_libdir/%name/*

%description
LMMS aims to be a free alternative to popular (but commercial and closed-
source) programs like FruityLoops, Cubase and Logic giving you the ability of
producing music with your computer by creating/synthesizing sounds, arranging
samples, using effects, playing live with keyboard and much more...

%package devel
Summary:	Development package for %name
Group:		Development/C
Requires: %name = %EVR

%description devel
Development files and headers for %name

%prep
%setup
%patch1 -p1
mv qt5-x11embed/* src/3rdparty/qt5-x11embed
mv rpmalloc/* src/3rdparty/rpmalloc/rpmalloc/
%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -name '*.cpp' | xargs -r sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%cmake \
    -DWANT_QT5=ON \
    -DCMAKE_INSTALL_LIBDIR=%_lib \
%ifarch %ix86
    -DWANT_VST:BOOL=ON \
%else
    -DWANT_VST:BOOL=OFF \
%endif
    -DWANT_SDL:BOOL=ON \
    -DWANT_PORTAUDIO:BOOL=ON \
    -DWANT_CAPS:BOOL=ON \
    -DWANT_TAP:BOOL=ON \
    -DWANT_SWH:BOOL=ON \
    -DWANT_CALF:BOOL=ON \
    -DWANT_VST_NOWINE:BOOL=ON \
    -DWANT_CARLA:BOOL=OFF

%cmake_build

%install
%cmake_install

rm -fr %buildroot%_datadir/bash-completion/completions/lmms

# remove static library
rm -f %buildroot%_libdir/*.a

%find_lang %name

%files -f %name.lang
%doc README.md LICENSE.txt doc/AUTHORS
%_bindir/*
%_libdir/%name/
%_datadir/%name/
%_man1dir/*
%_iconsdir/hicolor/*/apps/*
%_iconsdir/hicolor/*/mimetypes/*
%_desktopdir/*
%_datadir/mime/packages/*

%files devel
%_includedir/%name

%changelog
