%define _unpackaged_files_terminate_build 1

Name: log4cplus
Version: 2.0.6
Release: alt1
Summary: Logging library to C++
License: Apache-2.0 or BSD-2-Clause
Group: Development/C++
Url: http://log4cplus.sourceforge.net/

# https://github.com/log4cplus/log4cplus.git
Source: %name-%version.tar

# submodules
Source1: %name-%version-catch.tar
Source2: %name-%version-threadpool.tar

Patch1: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ doxygen graphviz swig
BuildRequires: python3-devel

%description
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

%package -n lib%name
Summary: Shared libraries of logging library to C++
Group: System/Libraries

%description -n lib%name
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

This package contains shared libraries of log4cplus.

%package -n lib%name-devel
Summary: Development files of logging library to C++
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

This package contains development files of log4cplus.

%package -n lib%name-devel-docs
Summary: Development documentation for logging library to C++
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-docs
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

This package contains development documentation and manpages for
log4cplus.

%package -n python3-module-%name
Summary: Python bindings of logging library to C++
Group: Development/Python3
Requires: lib%name = %EVR
%py3_provides %name

%description -n python3-module-%name
log4cplus is a simple to use C++ logging API providing thread-safe,
flexible, and arbitrarily granular control over log management and
configuration.  It is modeled after the Java log4j API.

This package contains Python bindings of log4cplus.

%prep
%setup -a1 -a2
%patch1 -p1

%build
export PYTHON=python3
%autoreconf
%configure \
	--enable-static=no \
	--enable-threads=yes \
	--with-working-c-locale \
	--with-python \
	%nil

sed -i 's|^\(SWIG =.*\)|\1 -py3|' $(find ./ -name Makefile)

%make_build

pushd docs
doxygen doxygen.config
popd

%install
%makeinstall_std

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
mkdir -p %buildroot%python3_sitelibdir/%name
mv %buildroot%python3_sitelibdir_noarch/%name/* %buildroot%python3_sitelibdir/%name/
%endif

install -d %buildroot%_man3dir
install -m644 docs/man/man3/* %buildroot%_man3dir

%check
%make check

%files -n lib%name
%doc LICENSE
%doc AUTHORS ChangeLog NEWS README* TODO
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-devel-docs
%doc docs/html/*
%_man3dir/*

%files -n python3-module-%name
%python3_sitelibdir/*

%changelog
