%def_without glibc_debuginfo
# turn on by:
# gear --commit -v --hasher -- hsh --build-args "--with glibc_debuginfo" -v ~/hasher 2>&1 | tee log

# TODO: fix tests
%def_without check

Name: ltrace
Version: 0.7.91.0.198.git82c6640
Release: alt4

Summary: Tracks runtime library calls from dynamically linked executables
License: GPLv2+
Group: Development/Debuggers
Url: http://ltrace.alioth.debian.org/

# git://anonscm.debian.org/collab-maint/ltrace.git
# https://github.com/dkogan/ltrace
Source: %name-%version.tar

# ===== RH Patches go here vvv =====
# RH Patches1-25 are included in git repo https://github.com/dkogan/ltrace

# GCC now warns (errors) on "tautological compares", and readdir_r is deprecated
Patch26: ltrace-0.7.91-tautology.patch

# ARM code has unreachable code after switch statement, move initialization
Patch27: ltrace-rh1423913.patch

# Patch28 makes braces unbalanced

# GCC-9 fix. Avoid passing NULL as argument to %%s
Patch29: ltrace-0.7.91-null.patch

# Patch30 is strange and obscure to me

# Patch31 is included in git repo

# Testsuite: AARCH64 ifuncs not supported yet yet
Patch32: ltrace-rh1225568.patch

# Patches33-34 are included in git repo

# GCC erroneously warns about uninitialized values
Patch35: ltrace-0.7.91-rh1799619.patch

# ===== ALT Patches goes here vvv =====
Patch1001: ltrace-0.7.91.0.198.git82c6640-fix_attach_process.patch
Patch1002: ltrace-0.7.91.0.198.git82c6640-fix_attach_process_dlopen.patch
# Patch1003 due Ltrace doesn't support long
# see: etc/libc.so-types.conf:# XXX ltrace misses long double and long long support
Patch1003: ltrace-0.7.91.0.198.git82c6640-disable_long_double_test_wchar.patch
Patch1004: ltrace-0.7.91.0.198.git82c6640-fix_errors_in_tests.patch
%{?_without_glibc_debuginfo:
Patch1005: ltrace-0.7.91.0.198.git82c6640-disable_glibc_core_debuginfo_tests.patch}

BuildRequires: libelf-devel elfutils-devel gcc-c++
%{?!_without_check:%{?!_disable_check:
BuildRequires: dejagnu /dev/pts /proc}}
%{?!_without_glibc_debuginfo:
BuildRequires: glibc-core-debuginfo}

Summary(ru_RU.UTF-8): Трассировщик библиотечных вызовов из динамически скомпонованных приложений

%description
Ltrace is a debugging program which runs a specified command until it
exits.  While the command is executing, ltrace intercepts and records
the dynamic library calls which are called by the executed process and
the signals received by that process.
It can also intercept and print the system calls executed by the program.

The program to be traced need not be recompiled for this, so you can
use it on binaries for which you don't have the source handy.

Optionally you can install glibc-core-debuginfo for obtaining extra
features of Ltrace.

%description -l ru_RU.UTF-8
Ltrace представляет из себя утилиту отладки, которая запускает указанную
пользователем команду и дожидается её завершения. Пока команда выполняется,
Ltrace перехватывает и выводит все выполняемые процессом вызовы подпрограмм
из динамических библиотек, все системные вызовы и все получаемые сигналы.

Трассируемую программу не требуется перекомпилировать, так что отлаживать
с помощью Ltrace можно даже те приложения, исходные тексты которых недоступны.

Опционально можно установить glibc-core-debuginfo для получения дополнительных
возможностей Ltrace.

%prep
%setup

%patch26 -p1
%patch27 -p1
%patch29 -p1
%patch32 -p1
%patch35 -p1

%patch1001 -p1
%patch1002 -p1
%patch1003 -p1
%patch1004 -p1
%{?_without_glibc_debuginfo:
%patch1005 -p1}

%build
export CFLAGS="%optflags -Werror"
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%check
[ -w /dev/ptmx -a -f /proc/self/maps ] || exit
LC_ALL=en_US.UTF-8 make check RUNTESTFLAGS="--tool_exec=%buildroot/%_bindir/ltrace CFLAGS_FOR_TARGET=" </dev/ptmx

%files
%_bindir/*
%_mandir/man?/*
%_datadir/%name
%doc COPYING CREDITS README TODO
%exclude %_docdir/%name

%changelog
