%def_with lua_compat

%global abi_version 5.1

Name: lua5.1
Version: 5.1.5
Release: alt17

Summary: Embeddable programming language
License: MIT
Group: Development/Other

URL: http://www.lua.org
Source: lua-%version.tar

Patch00: lua5.1-5.1.5-alt-at-ABI-compat.patch
Patch01: lua5.1-5.1.5-alt-at-ldo-abort.patch
Patch03: lua5.1-5.1.5-alt-at-luaconf-LUA_USE_LINUX.patch
Patch04: lua5.1-5.1.5-alt-at-restore-lua_version.patch
Patch05: lua5.1-5.1.5-alt-at-symbol-map.patch
Patch06: lua5.1-5.1.5-alt-doc.patch
Patch07: lua5.1-5.1.5-alt-pkgconfig.patch
Patch08: lua5.1-5.1.5-alt-safe-stack.patch
Patch09: lua5.1-5.1.5-lua.org-bugs-5.1.5-1.patch
Patch10: lua5.1-5.1.5-lua.org-bugs-5.1.5-2.patch
Patch11: lua5.1-5.1.5-alt-vseleznv-gcc6.patch
Patch12: lua-5.1.4-idsize.patch
Patch13: lua-5.1.4-lunatic.patch

Requires: lib%{name} = %EVR
Provides: lua = %version
Provides: lua5 = %version-%release
Obsoletes: lua5 <= 5.1.5-alt2
Conflicts: lua4

# if libreadline-devel changed, change Requires: in devel too
BuildRequires: libreadline-devel

%package -n lib%{name}
Summary: Embeddable programming language
Group: System/Libraries
# for smooth upgrade against lua5.1-alt-compat
Provides: %_libdir/lua/5.1
Provides: %_datadir/lua/5.1
Provides: lua(abi) = %abi_version
Requires: lib%{name}-preinstall = %EVR
Requires(pre): lib%{name}-preinstall = %EVR
Conflicts: lua5.1-alt-compat < 1.0.1

%package -n lib%{name}-devel
Summary: Embeddable programming language
Group: Development/Other
Provides: %{name}-devel = %EVR
Requires: lib%{name} = %EVR
Conflicts: asterisk-build-hacks < 0.0.2
Obsoletes: asterisk-build-hacks < 0.0.2
Provides: asterisk-build-hacks = 0.0.2
%if_with lua_compat
Requires: lib%{name}-compat-devel = %EVR
%endif
# it wasn't found automatically
Requires: libreadline-devel

%if_with lua_compat
# avoid provided dependency collision with modern lua
%filter_from_provides /^pkgconfig(lua)/d
%package -n lib%{name}-compat-devel
Summary: Embeddable programming language
Group: Development/Other
Provides: %{name}-compat-devel = %EVR
Requires: lib%{name}-devel = %EVR
Conflicts: liblua5.1-devel < 5.1.5-alt10
Conflicts: liblua4-devel
Conflicts: liblua5-devel  < 5.1.5-alt10
Conflicts: liblua5.3-devel
# added by request of rider@,https://bugzilla.altlinux.org/33223
Provides: liblua5-devel = %EVR
%endif

%package -n lib%{name}-devel-static
Summary: Embeddable programming language
Group: Development/Other
Provides: liblua5-devel-static = %version-%release
Requires: lib%{name}-devel = %EVR
Conflicts: liblua4-devel-static

%package -n lib%{name}-preinstall
Summary: preinstall package for lib%{name}
Group: Development/Other
Conflicts: lua5.1-alt-compat < 1.0.1

%package doc
Summary: Embeddable programming language
Group: Development/Documentation
Conflicts: lua5 < 5.1.1-alt2
BuildArch: noarch

%description
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%description -n lib%{name}
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%description -n lib%{name}-devel
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%if_with lua_compat
%description -n lib%{name}-compat-devel
This package contains lua.pc and liblua.so to help build old programs
unaware of lua5.1.
%endif

%description -n lib%{name}-devel-static
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%description -n lib%{name}-preinstall
virtual preinstall package for lib%{name} to resolve installation conflicts.

%description doc
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%prep
%setup -n lua-%version
%patch00 -p1
%patch01 -p1
%patch03 -p1
%patch04 -p1
%patch05 -p1
%patch06 -p1
%patch07 -p1
%patch08 -p1
%patch09 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

%build
%def_enable Werror

cd ./src
sed -i '/#define LUA_ROOT/s|/usr/local|%_prefix|' luaconf.h
sed -i '/#define LUA_CDIR/s|lib/|%_lib/|' luaconf.h
sed -i '/#define LUA_MAXINPUT/s|512|BUFSIZ|' luaconf.h

# from Makefile
core='lapi lcode ldebug ldo ldump lfunc lgc llex lmem lobject lopcodes lparser lstate lstring ltable ltm lundump lvm lzio'
lib='lauxlib lbaselib ldblib liolib lmathlib loslib ltablib lstrlib loadlib linit'

for f in $core $lib; do gcc %optflags -c $f.c; done
ar rcu liblua-5.1.a *.o
ranlib liblua-5.1.a

%define soffix -5.1.so.0
for f in $core $lib; do gcc %optflags %optflags_shared -c $f.c; done
gcc -shared -o liblua%soffix -Wl,-soname=liblua%soffix -Wl,--version-script=liblua.map -Wl,-z,defs *.o -lm -ldl

gcc -o lua %optflags lua.c ./liblua%soffix -lreadline
gcc -o luac %optflags luac.c print.c ./liblua%soffix

LD_LIBRARY_PATH=$PWD ./lua ../test/hello.lua

%install
%define pkgdocdir %_docdir/lua-5.1
mkdir -p %buildroot{%_libdir,%_bindir,%_includedir/lua-5.1,%_man1dir,%pkgdocdir/html}

cd ./src
cp -p liblua-5.1.a liblua%soffix %buildroot%_libdir/
ln -s liblua%soffix %buildroot%_libdir/liblua-5.1.so
ln -s liblua%soffix %buildroot%_libdir/liblua5.1.so
cp -p lua %buildroot%_bindir/lua-5.1
cp -p luac %buildroot%_bindir/luac-5.1
ln -s lua-5.1 %buildroot%_bindir/lua5.1
ln -s luac-5.1 %buildroot%_bindir/luac5.1
cp -p lua.h luaconf.h lualib.h lauxlib.h ../etc/lua.hpp %buildroot%_includedir/lua-5.1
ln -s lua-5.1 %buildroot%_includedir/lua5.1
install -pD -m644 ../etc/lua.pc %buildroot%_pkgconfigdir/lua-5.1.pc
ln -s lua-5.1.pc %buildroot%_pkgconfigdir/lua5.1.pc

# Fix paths in lua-5.1.pc:
sed -i 's|/usr/lib|%_libdir|g;s|/usr/share|%_datadir|g;' %buildroot%_pkgconfigdir/lua-5.1.pc

%if_with lua_compat
# compat symlinks that conflicts with other lua's -devels
ln -s liblua-5.1.so %buildroot%_libdir/liblua.so
ln -s lua-5.1.pc %buildroot%_pkgconfigdir/lua.pc
pushd %buildroot%_includedir/lua-5.1
for i in *.*; do
    ln -s lua-5.1/$i %buildroot%_includedir/$i
done
popd
%endif

cd ..
cp -av COPYRIGHT HISTORY README etc test %buildroot%pkgdocdir/
cd ./doc
cp -p lua.1 %buildroot%_man1dir/lua5.1.1
cp -p luac.1 %buildroot%_man1dir/luac5.1.1
cp -p *.html *.css *.gif *.png %buildroot%pkgdocdir/html/
mv %buildroot%pkgdocdir/html/{readme,index}.html

mkdir -p %buildroot{%_libdir,%_datadir}/lua/5.1

%pre -n lib%{name}
# ----------- begin update from old lua5 to lua5.1 ----
if [ -L %_libdir/lua/5.1 ]; then
    echo "removing lua5.1-alt-compat symlink..."
    rm -f %_libdir/lua/5.1
    if [ -d %_libdir/lua5 ]; then
	mkdir -p %_libdir/lua
	mv %_libdir/lua5 %_libdir/lua/5.1
    fi
fi
# ----------- end update from old lua5 to lua5.1 ----

%files
%_bindir/lua*
%_man1dir/lua*

%files -n lib%{name}
%_libdir/liblua%soffix
%dir %_libdir/lua
%dir %_datadir/lua
%dir %_libdir/lua/5.1
%dir %_datadir/lua/5.1
%dir %pkgdocdir
%pkgdocdir/COPYRIGHT
%pkgdocdir/HISTORY
%pkgdocdir/README

%files -n lib%{name}-devel
%_includedir/lua-5.1
%_includedir/lua5.1
%_libdir/liblua*5.1.so
%_pkgconfigdir/lua*5.1.pc

%if_with lua_compat
%files -n lib%{name}-compat-devel
%_libdir/liblua.so
%_pkgconfigdir/lua.pc
%_includedir/*.h
%_includedir/*.hpp
%endif

%files -n lib%{name}-devel-static
%_libdir/liblua-5.1.a

%files -n lib%{name}-preinstall

%files doc
%dir %pkgdocdir
%pkgdocdir/html
%pkgdocdir/etc
%pkgdocdir/test

%changelog
