#TODO:
#   1. check rpath is clear
%define oname luarocks

Name: lua5.3-luarocks
Version: 2.4.2
Release: alt7
Summary: A deployment and management system for Lua modules
License: MIT
Group: Development/Tools
Url: http://www.luarocks.org
Provides: %oname = %EVR
Obsoletes: %oname < %EVR
Conflicts: rpm-macros-lua < 1.4
#This is %%luarocks_dbdir_prefix-%current_lua_version
#	which is defined in rpm-macros-lua package
Provides: %_prefix/lib/luarocks/rocks-5.3
Requires: chrpath wget p7zip unzip zip

Source: http://luarocks.org/releases/%name-%version.tar
#.gz
Source1: %oname.filetrigger
Source2: %oname-files.req.list

BuildPreReq: rpm-macros-lua >= 1.4
# Automatically added by buildreq on Wed Sep 20 2017
# optimized out: lua5.3 python-base
BuildRequires: lua-devel lua5.1 unzip wget

%description
LuaRocks allows you to install Lua modules as self-contained
packages called "rocks", which also contain version dependency
information. This information is used both during installation,
so that when one rock is requested all rocks it depends on are
installed as well, and at run time, so that when a module is
required, the correct version is loaded. LuaRocks supports both
local and remote repositories, and multiple local rocks trees.

This is the instance for lua 5.3

%package -n lua5.1-luarocks
Summary: A deployment and management system for Lua modules
License: MIT
Group: Development/Tools
#This is %%luarocks_dbdir_prefix-%current_lua_version
#	which is defined in rpm-macros-lua package
Provides: %_prefix/lib/luarocks/rocks-5.1
Requires: chrpath wget p7zip unzip zip
Conflicts: %oname < %EVR
Conflicts: lua5.3-luarocks < %EVR
Conflicts: lua5.3-luarocks > %EVR
Conflicts: %oname < %EVR
Conflicts: rpm-macros-lua < 1.4

%description -n lua5.1-luarocks
LuaRocks allows you to install Lua modules as self-contained
packages called "rocks", which also contain version dependency
information. This information is used both during installation,
so that when one rock is requested all rocks it depends on are
installed as well, and at run time, so that when a module is
required, the correct version is loaded. LuaRocks supports both
local and remote repositories, and multiple local rocks trees.

This is the instance for lua 5.1

%prep
%setup
#disable Lua header version check
sed -i 's/^if .*header_version.*LUA_VERSION.*$/if [ OK ]/' configure

%build
for v in 5.1 5.3; do
	cp -a . ../build-$v
	pushd ../build-$v
	./configure --prefix=%prefix --lua-version=$v \
		--versioned-rocks-dir
	make
	popd
done

%install
for v in 5.1 5.3; do
	%makeinstall_std -C ../build-$v
	sed -i "s|/usr/bin/env lua$|/usr/bin/env lua$v|" %buildroot%_bindir/%{oname}*-$v
	mkdir -p %buildroot{%_datadir/lua/$v/%oname/,%luarocks_dbdir_prefix-$v/}
	#move arch-dependent parts
	# pending https://github.com/keplerproject/luarocks/issues/86
	mkdir -p %buildroot%_libdir/lua/$v/%oname
	mv %buildroot%_datadir/lua/$v/%oname/site_config.lua \
		%buildroot%_libdir/lua/$v/%oname
	#enable lib -> lib64 right path settings
	cat >> %buildroot%_sysconfdir/%oname/config-$v.lua <<EOF
gcc_rpath = false
lib_modules_path = "/%_lib/lua/"..lua_version
EOF

SITECFG_ADDITION="site_config.LUAROCKS_EXTERNAL_DEPS_SUBDIRS =\\
    {\\
      bin = \"bin\",\\
      lib = \"%_lib\",\\
      include = \"include\"\\
    }"
sed -i "/^return/ i $SITECFG_ADDITION" \
	%buildroot%_libdir/lua/$v/%oname/site_config.lua
	#%%ghost
	touch %buildroot%luarocks_dbdir_prefix-$v/{index.html,manifest{,-5.{1,2,3}}}
done

# RPM triggers
mkdir -p %buildroot%_rpmlibdir/
install -m755 %SOURCE1 %buildroot%_rpmlibdir/
install -m644 %SOURCE2 %buildroot%_rpmlibdir/

%files
%dir %_sysconfdir/%oname
%_sysconfdir/%oname/*-5.3.*
%_bindir/%{oname}*-5.3
%dir %_prefix/lib/luarocks
%dir %luarocks_dbdir_prefix-5.3
%ghost %luarocks_dbdir_prefix-5.3/index.html
%ghost %luarocks_dbdir_prefix-5.3/manifest*
%_rpmlibdir/%{oname}*
%lua53_modulesdir/%oname
%lua53_modulesdir_noarch/%oname
%doc COPYING README*

%files -n lua5.1-luarocks
%dir %_sysconfdir/%oname
%_sysconfdir/%oname/*-5.1.*
%_bindir/%{oname}*-5.1
%dir %_prefix/lib/luarocks
%dir %luarocks_dbdir_prefix-5.1
%ghost %luarocks_dbdir_prefix-5.1/index.html
%ghost %luarocks_dbdir_prefix-5.1/manifest*
%_rpmlibdir/%{oname}*
%lua51_modulesdir/%oname
%lua51_modulesdir_noarch/%oname
%doc COPYING README*

%changelog
