%define target_lua_version 5.3

# Original package name LuaFileSystem
%define oname luafilesystem
%define oversion 1.7.0-2
%define otagversion 1_7_0_2
%define rockspec luafilesystem-1.7.0-2.rockspec
Name: lua%target_lua_version-module-%oname
Version: 1.7.0
Release: alt1_lr2
Summary: File System Library for the Lua Programming Language
License: MIT/X11
Group: Development/Other
Url: http://www.keplerproject.org/luafilesystem/
Provides: luarocks%target_lua_version(%oname) = %EVR

%if "%target_lua_version" == "5.3"
Obsoletes: lua-module-%oname < %version
Provides: lua-module-%oname = %version
%else
Obsoletes: lua5-%oname < %version
Provides: lua5-%oname = %version
%endif

# https://github.com/keplerproject/luafilesystem/archive/v1_7_0_2.tar.gz
Source: %oname-%otagversion.tar.gz
Source1: https://luarocks.org/manifests/luarocks/luafilesystem-1.7.0-2.rockspec

BuildPreReq: rpm-macros-lua >= 1.4
# Automatically added by buildreq on ...
BuildRequires: liblua%target_lua_version-devel lua%target_lua_version-luarocks

%description
      LuaFileSystem is a Lua library developed to complement the set of
      functions related to file systems offered by the standard Lua
      distribution. LuaFileSystem offers a portable way to access the
      underlying directory structure and file attributes.

%prep
%setup -n %oname-%otagversion

%install
%luarocks_make %SOURCE1
%luarocks_move_docs doc

%check
%lua_path_add_buildroot
for t in %buildroot%luarocks_dbdir/%oname/%oversion/tests/* ; do
  lua%target_lua_version $t
done

%files
%lua_modulesdir/*
%luarocks_dbdir/%oname
%doc README* docs_from_rockstree/*
%exclude %luarocks_dbdir/manifest

%changelog
