#
# lxc: linux Container library
#
# (C) Copyright IBM Corp. 2007, 2008
# (C) ALT Linux Team 2009-2021
#
# Authors:
# Daniel Lezcano <dlezcano at fr.ibm.com>
# Denis Pynkin <dans at altlinux.org>
# Vladimir D. Seleznev <vseleznv at altlinux.org>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Spec file adapted for ALT Linux.

%define sover 1
%def_with systemd
%def_disable static_init

# Skip automatic dependency to optional lsb scripts
%add_findreq_skiplist %_initdir/*

# Needed to disable auto requirements from distro templates
%add_findreq_skiplist %_datadir/lxc/*

# Do not need to check
%add_findreq_skiplist %_libexecdir/lxc/lxc-apparmor-load
%add_findreq_skiplist %_libexecdir/lxc/lxc-net


Name: lxc
Version: 4.0.12
Release: alt3

Summary: Linux Containers

License: LGPL-2.1-or-later
Group: System/Configuration/Other
Url: https://linuxcontainers.org/

VCS: https://github.com/lxc/lxc.git
Source0: lxc-%version.tar
Source1: lxc-net.sysconfig
Source2: lxc-user-nic.control
Source3: lxc.watch
Source4: 30-lxc-inotify.conf

# git://git.altlinux.org:/gears/l/lxc.git
Patch: %name-%version-%release.patch

Requires: lxc-core lxc-net lxc-templates

BuildRequires(pre): rpm-macros-pam
BuildRequires: docbook2X
BuildRequires: libpam-devel
BuildRequires: libcap-devel
BuildRequires: libseccomp-devel libselinux-devel libssl-devel
BuildRequires: pkgconfig(systemd)
%{?_enable_static_init:BuildRequires: libcap-devel-static}

%description
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This is meta package.

%package core
Summary: Core package for LXC
Group: System/Configuration/Other
Requires: rsync
Requires: service
%ifarch x86_64 aarch64 ppc64le
Requires: criu >= 3.15
%endif
Obsoletes: lxc-sysvinit < %EVR

%package net
BuildArch: noarch
Summary: Network interface for LXC with DHCP
Group: System/Configuration/Networking
Requires: iproute2 dnsmasq lxc-core iptables

%package templates
BuildArch: noarch
Summary: Templates for LXC
Group: System/Configuration/Other
Requires: lxc-core wget

%package -n liblxc%sover
Summary: LXC shared runtime library
Group: System/Libraries
Requires: lxc-runtime

%package runtime
Summary: Runtime files for LXC
Group: System/Configuration/Other
Provides: lxc-libs = %EVR
Obsoletes: lxc-libs < %EVR
Requires(pre): /usr/sbin/groupadd

%package -n liblxc-devel
Summary: Development files for LXC
Group: Development/Other
Provides: lxc-devel = %EVR

%set_pam_name pam_cgfs
%package -n %pam_name
Summary: %summary
Group: System/Base

%description core
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package provides the lxc-* tools, which can be used to start a single
daemon in a container, or to boot an entire "containerized" system, and to
manage and debug your containers.

%description net
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package provides the network interface for containers with DHCP.

%description templates
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package contains templates for LXC.

%description -n liblxc%sover
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package contains runtime shared library for LXC.

%description runtime
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package contains runtime executables and data for LXC.

%description -n liblxc-devel
Containers are insulated areas inside a system, which have their own namespace
for filesystem, network, PID, IPC, CPU and memory allocation and which can be
created using the Control Group and Namespace features included in the Linux
kernel.

This package contains development files for LXC.

%description -n %pam_name
%summary
This package provides a Pluggable Authentication Module (PAM) to provide
logged-in users with a set of cgroups which they can administer.
This allows for instance unprivileged containers, and session
management using cgroup process tracking.

%prep
%setup
%autopatch -p1
%ifarch %e2k
echo -e "#undef ARRAY_SIZE\n#define ARRAY_SIZE(x) (sizeof(x)/sizeof(*(x)))" >> src/lxc/macro.h
%endif

%build
export bashcompdir="%_datadir/bash-completion/completions"
%autoreconf
%configure \
	--disable-werror \
	--disable-cgmanager \
	--disable-rpath \
	--disable-static \
	--enable-capabilities \
	--enable-pam \
	--enable-seccomp \
	--enable-selinux \
	--localstatedir=%_var \
	--with-config-path=%_var/lib/lxc \
	--with-distro=altlinux \
	--with-init-script=%{?_with_systemd:systemd,}sysvinit

%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_localstatedir/lxc
install -pm644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/lxc-net
install -pDm755 %SOURCE2 %buildroot%_controldir/lxc-user-nic
install -pDm644 %SOURCE4 %buildroot%_sysctldir/30-lxc-inotify.conf

rm %buildroot%_datadir/lxc/lxc-patch.py

%post core
usermod --add-subgids 100000-165535 --add-subuids 100000-165535 root ||:
if [ $1 -eq 1 ]; then
	/sbin/chkconfig --add lxc ||:
fi

%preun core
if [ $1 -eq 0 ]; then
	/sbin/chkconfig --del lxc ||:
fi

%post net
if [ $1 -eq 1 ]; then
	/sbin/chkconfig --add lxc-net ||:
fi

%preun net
if [ $1 -eq 0 ]; then
	/sbin/chkconfig --del lxc-net ||:
fi

%pre runtime
groupadd -r -f vmusers ||:
%pre_control lxc-user-nic

%post runtime
%post_control -s vmusers lxc-user-nic

%files

%files core
%doc COPYING doc/FAQ.txt

%dir %_sysconfdir/lxc
%dir %_sysconfdir/sysconfig/lxc
%config(noreplace) %_sysconfdir/lxc/*
%config(noreplace) %_sysconfdir/sysconfig/lxc*
%_sysctldir/30-lxc-inotify.conf
%_datadir/bash-completion/completions/*

%_bindir/lxc-*
%_datadir/lxc/config
%_datadir/lxc/selinux

%dir %_defaultdocdir/lxc
%_defaultdocdir/lxc/examples

%_man1dir/lxc*
%_man5dir/lxc*
%_man7dir/lxc*

%dir %_mandir/ja
%dir %_mandir/ko
%_mandir/ja/*
%_mandir/ko/*

%_initdir/lxc

%if_with systemd
%_unitdir/lxc.service
%_unitdir/lxc@.service
%endif

%files net
%_libexecdir/lxc/lxc-net

%_initdir/lxc-net

%if_with systemd
%_unitdir/lxc-net.service
%endif

%files templates
%dir %_datadir/lxc
%_datadir/lxc/templates

%files -n liblxc%sover
%_libdir/liblxc.so.%sover
%_libdir/liblxc.so.%sover.*

%files runtime
%attr(4710,root,vmusers) %_libexecdir/lxc/lxc-user-nic
%_libexecdir/lxc/lxc-containers

%_libexecdir/lxc/lxc-apparmor-load
%_libexecdir/lxc/lxc-containers
%_libexecdir/lxc/lxc-monitord
%_libexecdir/lxc/hooks

%_controldir/lxc-user-nic
%_datadir/lxc/hooks
%_datadir/lxc/lxc.functions

%_sbindir/init.lxc*
%_localstatedir/lxc

%dir %_datadir/lxc
%dir %_libexecdir/lxc
%dir %_libdir/lxc
%dir %_libdir/lxc/rootfs
%_libdir/lxc/rootfs/README

%files -n liblxc-devel
%_includedir/lxc
%_libdir/liblxc.so
%_pkgconfigdir/lxc.pc

%files -n %pam_name
%_pam_modules_dir/*
%_man8dir/pam_cgfs.8*

%changelog
