Name: mapsoft
Version: 20210121
Release: alt1
License: GPL3.0

Summary: mapsoft - programs for working with maps and geodata
Group: Sciences/Geosciences
Url: http://github.org/ushakov/mapsoft
Packager: Vladislav Zavjalov <slazav@altlinux.org>

Source: %name-%version.tar
Patch1: 0001-skip-convs_gtiles.patch

BuildRequires: boost-devel gcc-c++ libcurl-devel libzip-devel zlib-devel
BuildRequires: libcairomm-devel libpixman-devel libgtkmm2-devel
BuildRequires: libpng-devel libjpeg-devel libtiff-devel libgif-devel
BuildRequires: libusb-devel libyaml-devel libxml2-devel proj-devel
BuildRequires: libjansson-devel libshape-devel
BuildRequires: python-devel scons swig m4
BuildRequires: /usr/bin/gs netpbm transfig ImageMagick-tools /usr/bin/pod2man
BuildRequires: boost-geometry-devel perl-Text-Iconv

%package tools
Summary: mapsoft-tools - rarely-used tools from mapsoft package
Group: Sciences/Geosciences
Requires: %name = %version-%release

%package vmap
Summary: mapsoft-vmap - programs for working with vector maps
Group: Sciences/Geosciences
Requires: %name = %version-%release

%description
mapsoft - programs for working with maps and geodata

%description tools
mapsoft-tools - rarely-used tools from mapsoft package

%description vmap
mapsoft-vmap - programs for working with vector maps

%prep
%setup -q
%patch1 -p1

%build
# boost::spirit crashes with -O2 on 32-bit systems
%if "%_lib" == "lib64"
export CCFLAGS=-O2
%endif

scons -Q minimal=1

%install
scons -Q minimal=1 -Q prefix=%buildroot install

%files
%_bindir/mapsoft_convert
%_bindir/mapsoft_mapview
%_mandir/man1/mapsoft_convert.*
%_mandir/man1/mapsoft_mapview.*
%_desktopdir/mapsoft_mapview.*

%files tools
%_bindir/convs_*
%_bindir/mapsoft_toxyz
%_bindir/mapsoft_geofig
%_bindir/mapsoft_mkmap
%_mandir/man1/mapsoft_geofig.*
%_libdir/gimp/2.0/plug-ins/map-helper.py

%files vmap
%_bindir/mapsoft_vmap
%_bindir/vmap_copy
%_bindir/vmap_render
%dir %_datadir/mapsoft
%_datadir/mapsoft/*
%_datadir/xfig/Libraries/*
%_mandir/man1/mapsoft_vmap.*
%_bindir/map_rescale
%_bindir/*.sh
%_bindir/map_*_gk
%_bindir/map_*_nom
%_bindir/mapsoft_wp_parse

%changelog
