%def_disable snapshot

%define ver_major 0.64
%define libname mesonbuild
%define pkgdocdir %_docdir/%name-%version

# pkexec may be used to "gain elevated privileges" during install
%def_without polkit
# since 0.59 https://wrapdb.mesonbuild.com/v2/releases.json
# required for tools/regenerate_docs.py
%def_disable docs
%def_disable check

Name: meson
Version: %ver_major.1
Release: alt0.P10.1

Summary: High productivity build system
Group: Development/Python3
License: Apache-2.0
Url: https://mesonbuild.com/

%if_disabled snapshot
Source: https://github.com/mesonbuild/meson/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

Source1: %name.macros
Source2: %name.env
Patch0: meson-0.64-deprecate-positional-arg-i18n.patch
Patch1: meson-0.64-revert-coredata-throw-a-MesonException-on-unknown-op.patch
Patch2: meson-0.64-revert-decorators-Make-unknown-kwarg-fatal.patch
Patch3: meson-0.64-revert-use-shared-implementation-to-convert-files-st.patch

BuildArch: noarch

%define python_ver 3.7
Requires: rpm-macros-%name = %EVR
Requires: python3 >= %python_ver
Requires: ninja-build >= 1.7
# since 0.58.0 some builds fail for 64-bit without /proc, need investigate.
Requires: /proc

#grep -n "from __main__" -r *
#mesonbuild/minstall.py:23:from __main__ import __file__ as main_file
%add_python3_req_skip __main__
# M$ VC++ runtime
%add_python3_req_skip msvcrt
%{?_with_polkit:Requires: polkit}

BuildRequires(pre): rpm-build-python3
BuildRequires: ninja-build python3-devel >= %python_ver python3-module-setuptools
BuildRequires: python3-module-wheel
%{?_with_polkit:BuildRequires: libpolkit-devel}
%{?_enable_docs:BuildRequires: hotdoc}
%if_enabled check
BuildRequires: gcc gcc-c++ gcc-fortran gcc-objc gcc-objc++
BuildRequires: java-devel /proc
BuildRequires: mono-core mono-devel
BuildRequires: boost-devel
BuildRequires: libgtest-devel
BuildRequires: libgmock-devel
BuildRequires: qt5-base-devel
BuildRequires: vala
BuildRequires: libwxGTK3.0-devel
BuildRequires: flex bison
BuildRequires: gnustep-base-devel
BuildRequires: git
BuildRequires: pkgconfig(protobuf) protobuf-c-compiler
BuildRequires: pkgconfig(gobject-introspection-1.0) python3-module-pygobject3 gtk-doc
BuildRequires: pkgconfig(zlib)
BuildRequires: python3-module-Cython
%endif

%description
Meson is a build system designed to optimize programmer productivity.
It aims to do this by providing simple, out-of-the-box support for modern
software development tools and practices, such as unit tests, coverage
reports, Valgrind, CCache and the like.

%package -n rpm-macros-%name
Summary: RPM macros for Meson build system
Group: Development/Other
BuildArch: noarch

%description -n rpm-macros-%name
This package provides RPM macros for Meson build system.

%package doc
Summary: Meson build system documetation
Group: Development/Documentation
Conflicts: %name < %version

%description doc
This package provides documentation for Meson build system.

%prep
%setup
%patch0 -p2
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%pyproject_build
%{?_enable_docs:
pushd docs
mkdir build
export PYTHONPATH=%buildroot%python3_sitelibdir
../meson.py build
ninja -C build
popd}

%install
%pyproject_install
install -Dpm 0644 %SOURCE1 %buildroot%_rpmmacrosdir/%name
install -Dpm 0755 %SOURCE2 %buildroot%_rpmmacrosdir/%name.env

%{?_enable_docs:
mkdir -p %buildroot%pkgdocdir
cp -a "docs/build/Meson documentation-doc/html" \
COPYING README.* %buildroot%pkgdocdir/}

%check
export LC_ALL=en_US.utf8
MESON_PRINT_TEST_OUTPUT=1 ./run_tests.py

%files
%_bindir/%name
%python3_sitelibdir/%libname/
%python3_sitelibdir/%{pyproject_distinfo %name}
%{?_without_polkit:
%exclude }%_datadir/polkit-1/actions/com.mesonbuild.install.policy
%_man1dir/%name.1.*
%{?_disabled_docs:%doc COPYING README.*}

%files -n rpm-macros-%name
%_rpmmacrosdir/%name
%_rpmmacrosdir/%name.env

%if_enabled docs
%files doc
%pkgdocdir/
%endif

%changelog
