%define sover 1
Name: metis
Version: 5.1.0
Release: alt2
Summary: Family of Multilevel Partitioning Algorithms
License: GPL
Group: Sciences/Mathematics
Url: http://glaros.dtc.umn.edu/gkhome/views/metis
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
Source1: %name.pc

BuildPreReq: cmake gcc-c++ libpcre-devel

%description
METIS is a software package for partitioning unstructured graphs,
partitioning meshes, and computing fill-reducing orderings of sparse
matrices.

%package -n lib%name
Summary: Shared library of METIS
Group: System/Libraries

%description -n lib%name
METIS is a software package for partitioning unstructured graphs,
partitioning meshes, and computing fill-reducing orderings of sparse
matrices.

This package contains shared library of METIS.

%package -n lib%name-devel
Summary: Development files of METIS
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
METIS is a software package for partitioning unstructured graphs,
partitioning meshes, and computing fill-reducing orderings of sparse
matrices.

This package contains development files of METIS.

%package -n lib%name-devel-doc
Summary: Development documentation of METIS
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
METIS is a software package for partitioning unstructured graphs,
partitioning meshes, and computing fill-reducing orderings of sparse
matrices.

This package contains development documentation of METIS.

%package examples
Summary: Example graphs for METIS
Group: Development/Documentation
BuildArch: noarch

%description examples
METIS is a software package for partitioning unstructured graphs,
partitioning meshes, and computing fill-reducing orderings of sparse
matrices.

METIS is written in ANSI C and should compile on Unix systems that have
a ANSI C compiler.

This package contains example graphs for METIS.

%prep
%setup
install -m644 %SOURCE1 .

%build
FLAGS="%optflags -I%_includedir/pcre"
cmake \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DCMAKE_C_FLAGS:STRING="$FLAGS" \
	-DCMAKE_CXX_FLAGS:STRING="$FLAGS" \
	-DCMAKE_Fortran_FLAGS:STRING="$FLAGS" \
	-DCMAKE_STRIP:FILEPATH="bin/echo" \
	-DPCRE:BOOL=ON \
	-DSOVER=%sover \
	.

%make_build VERBOSE=1
sed -i 's|@VERSION@|%version|' %name.pc

%install
%makeinstall_std
%if "%_libexecdir" != "%_libdir"
	install -d %buildroot%_libdir
	mv %buildroot%_libexecdir/* %buildroot%_libdir/
%endif

install -d %buildroot%_includedir/%name
mv %buildroot%_includedir/*.h %buildroot%_includedir/%name/

install -d %buildroot%_docdir/%name
install -d %buildroot%_datadir/%name
install -d %buildroot%_pkgconfigdir

install -m644 manual/*.pdf %buildroot%_docdir/%name
install -m644 graphs/* %buildroot%_datadir/%name

install -m644 %name.pc %buildroot%_pkgconfigdir

%pre -n lib%name-devel
rm -fR %_libexecdir/metis

%files
%doc Changelog LICENSE.txt
%_bindir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_docdir/%name

%files examples
%_datadir/%name

%changelog
