Name: minidlna
Version: 1.3.0
Release: alt1

Summary: DLNA AV Media Server
License: GPLv2
Group: System/Servers
Url: http://sourceforge.net/projects/minidlna/

Source: %name-%version-%release.tar

BuildRequires: libjpeg-devel libexif-devel libid3tag-devel libogg-devel
BuildRequires: libvorbis-devel libflac-devel libsqlite3-devel
BuildRequires: libavcodec-devel libavformat-devel libavutil-devel

%description
%summary

%prep
%setup
sed -i '/user=/ s,^.\+$,user=_minidlna,' minidlna.conf

%build
%autoreconf
%configure --with-os-url='http://www.altlinux.org'
%make_build

%install
%makeinstall_std
install -pm0644 -D minidlna.conf %buildroot%_sysconfdir/minidlna.conf
install -pm0644 -D minidlna.conf.5 %buildroot%_man5dir/minidlna.conf.5
install -pm0644 -D minidlnad.8 %buildroot%_man8dir/minidlnad.8
install -pm0755 -D minidlna.init %buildroot%_initdir/minidlna
install -pm0644 -D minidlna.sysconfig %buildroot%_sysconfdir/sysconfig/minidlna
install -pm0644 -D minidlna.service %buildroot%_unitdir/minidlna.service
mkdir -p %buildroot%_cachedir/%name

%find_lang %name

%pre
/usr/sbin/groupadd -r -f _minidlna &>/dev/null ||:
/usr/sbin/useradd -r -g _minidlna -d %_cachedir/%name -s /dev/null \
    -c "minidlna service" -M -n _minidlna &>/dev/null ||:

%post
%post_service minidlna

%preun
%preun_service minidlna

%files -f %name.lang
%doc AUTHORS COPYING NEWS README
%config(noreplace) %_sysconfdir/minidlna.conf
%config(noreplace) %_sysconfdir/sysconfig/minidlna

%_initdir/minidlna
%_unitdir/minidlna.service

%_sbindir/minidlnad
%_man5dir/minidlna.conf.5*
%_man8dir/minidlnad.8*

%dir %attr(0770,root,_minidlna) %_cachedir/%name

%changelog
