%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

# LTO causes errors on armh, disable it
%global optflags_lto %nil

%def_disable debug
%def_disable profiling

%def_enable qt
%def_with flac
%def_with dvdread

%undefine _configure_gettext

Name: mkvtoolnix
Version: 74.0.0
Release: alt1.1
Summary: Tools to create, alter and inspect Matroska files
License: GPL-2
Group: Video
Url: https://mkvtoolnix.download/

# https://gitlab.com/mbunkus/mkvtoolnix.git
Source: %name-%version.tar

Provides: mkvmerge = %EVR

BuildRequires(pre): rpm-build-xdg
BuildRequires: gcc-c++ boost-devel boost-filesystem-devel zlib-devel libmagic-devel
BuildRequires: libgmp-devel
BuildRequires: libvorbis-devel libogg-devel
BuildRequires: /usr/bin/rake
BuildRequires: libebml-devel >= 1.4.4 libmatroska-devel >= 1.7.1 libfmt-devel >= 6.1.0
BuildRequires: docbook-style-xsl xsltproc
BuildRequires: libpugixml-devel
BuildRequires: po4a
BuildRequires: libgtest-devel
BuildRequires: libpcre2-devel
BuildRequires: libutfcpp-devel
BuildRequires: nlohmann-json-devel

%{?_enable_qt:BuildRequires: qt5-base-devel qt5-tools qt5-multimedia-devel qt5-svg-devel cmark-devel}
%{?_with_flac:BuildRequires: libflac-devel}
%{?_with_dvdread:BuildRequires: libdvdread-devel}

%description
Matroska is a new multimedia file format aiming to become the new
container format for the future.
With these tools one can extract tracks/data from (mkvextract) Matroska
files and create (mkvmerge) Matroska files from other media files.

%if_enabled qt
%package gui
Summary: GUI for mkvmerge including a chapter editor
Group: Video
Provides: mmg = %EVR
Provides: mkvmerge-gui = %EVR
Obsoletes: mkvmerge-gui < %EVR
Requires: %name = %EVR
Requires: mkvinfo = %EVR

%description gui
Matroska is a new multimedia file format aiming to become the new
container format for the future.
mkvmerge GUI is a Qt based GUI for mkvmerge. It offers easy
access to all of mkvmerge's options. All settings (e.g. source files,
track options etc) can be saved and restored. Included is a chapter
editor that can read OGM style and XML style chapter files, write XML
style chapter files and even read chapters from Matroska files and
write chapters directly to Matroska files.
%endif

%package -n mkvinfo
Summary: Tool for print information about tracks in Matroska files
Group: Video

%description -n mkvinfo
Matroska is a new multimedia file format aiming to become the new
container format for the future.
With mkvinfo you can get information about Matroska files. This program
lists all tracks contained in a Matroska file including information
about the codecs used.

%prep
%setup

# remove some bundled libraries
rm -rf lib/nlohmann-json lib/pugixml lib/utf8-cpp

%ifarch %e2k riscv64
sed -i 's,aarch64,&|riscv64|e2k,' ac/ax_boost_base.m4
%endif

%build
./autogen.sh
%configure \
    --disable-update-check \
    --disable-optimization \
    %{subst_enable debug} \
    %{subst_enable profiling} \
    %{subst_enable qt} \
%if_enabled qt
    ac_cv_path_LCONVERT=%_bindir/lconvert-qt5 \
%endif
    %{subst_with flac} \
    %{subst_with dvdread} \
    %nil

rake V=1

%install
rake DESTDIR=%buildroot install

%find_lang --with-man %name
%find_lang --with-man %name-gui
%find_lang --with-man mkvextract
%find_lang --with-man mkvmerge
%find_lang --with-man mkvpropedit
%find_lang --with-man mkvinfo

cat mkvextract.lang mkvmerge.lang mkvpropedit.lang >> %name.lang

%check
rake V=1 tests:unit
rake V=1 tests:run_unit

%files -f %name.lang
%doc COPYING
%doc AUTHORS NEWS.md README.md CODE_OF_CONDUCT.md
%doc examples
%_bindir/mkvextract
%_bindir/mkvmerge
%_bindir/mkvpropedit
%_man1dir/mkvextract.*
%_man1dir/mkvmerge.*
%_man1dir/mkvpropedit.*
%_iconsdir/hicolor/*/apps/mkvextract.*
%_iconsdir/hicolor/*/apps/mkvmerge.*
%_iconsdir/hicolor/*/apps/mkvpropedit.*

%files -n mkvinfo -f mkvinfo.lang
%doc COPYING
%doc AUTHORS NEWS.md README.md CODE_OF_CONDUCT.md
%_bindir/mkvinfo
%_man1dir/mkvinfo.*
%_iconsdir/hicolor/*/apps/mkvinfo.*

%if_enabled qt
%files gui -f %name-gui.lang
%doc COPYING
%doc AUTHORS NEWS.md README.md CODE_OF_CONDUCT.md
%_bindir/%name-gui
%_man1dir/%name-gui.*
%_iconsdir/hicolor/*/apps/%name-gui.*
%_desktopdir/org.bunkus.%name-gui.desktop
%_xdgmimedir/packages/org.bunkus.%name-gui.xml
%_datadir/mkvtoolnix/sounds/*.webm
%_datadir/metainfo/org.bunkus.%name-gui.appdata.xml
%endif

%changelog
