BuildRequires: desktop-file-utils
Name: moto4lin
Version: 0.3
Release: alt7.qa2

Summary: File manager for Motorola P2K phones
Summary(ru_RU.CP1251):        Motorola P2K
License: %gpl2plus
Group: Communications

Url: http://moto4lin.sf.net/

Source0: %name-%version.tar
Source1: %name.rules
Source2: %name.png
Patch0: %name-svn-r82-crossplatform.patch

Packager: Mobile Development Team <mobile@packages.altlinux.org>

BuildPreReq: ImageMagick gcc-c++ libusb-compat-devel
BuildPreReq: libqt3-devel >= 3.3.0
BuildRequires(pre): rpm-build-licenses

%description
File manager and seem editor for Motorola P2K phones (C3x0, C650, V300,
V500, V600, E398, T720, T722 etc.).

This is alpha version, use it at your own risk (you should backup all
files from your phone before using this program).

%description -l ru_RU.CP1251
    seem  P2K- Motorola (C3x0, C650, V300,
V500, V600, E398, T720, T722  .).

  -,       . 
        .

%prep
%setup
%patch -p1
sed -i "s,debug,," moto_ui/moto_ui.pro

%build
lrelease-qt3 moto_ui/moto_ui.pro
qmake-qt3 "CONFIG+=no_fixpath"
%make_build QMAKE=qmake-qt3
convert -border 0x8 -bordercolor none -depth 8 %SOURCE2 %name-64.png
for s in 48 36 32 24 22 16; do
    convert -depth 8 -resize ${s}x$s %name{-64,-$s}.png
done


%install
%make_install INSTALL_ROOT=%buildroot install
install -pD -m644 %SOURCE1 %buildroot%_udevrulesdir/75-%name.rules
for s in 64 48 36 32 24 22 16; do
    install -D -m 0644 {%name-$s,%buildroot%_iconsdir/hicolor/${s}x$s/apps/%name}.png
done
install -d -m 0755 %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%name.desktop <<__MENU__
[Desktop Entry]
Version=1.0
Name=%name
GenericName=Filemanager for Motorola P2k phones
Comment=Upload ringtones and download photos.
Exec=%name
Icon=%name
Terminal=false
Type=Application
Categories=Qt;Utility;PDA;
__MENU__
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=TelephonyTools \
	%buildroot%_desktopdir/moto4lin.desktop


%files
%_udevrulesdir/*
%_bindir/*
%_datadir/%name/
%doc Changelog INSTALL README
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*


%changelog
