Name: mousepad
Version: 0.6.5
Release: alt1

Summary: Mousepad - A simple text editor for Xfce
Summary (ru_RU.UTF-8): Простой текстовый редактор для Xfce
License: GPLv2+
Group: Editors
Url: https://docs.xfce.org/apps/mousepad/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/apps/mousepad.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: rpm-build-xfce4 xfce4-dev-tools >= 4.18.0
BuildRequires: libgtk+3-devel libgtksourceview4-devel
# For xgettext to parse the `.policy` file
BuildRequires: libpolkit-devel
# For gspell plugin
BuildRequires: libgspell-devel
# For shortcuts plugin
BuildRequires: libxfce4ui-gtk3-devel

Obsoletes: xfce-mousepad < %version
Provides: xfce-mousepad = %version-%release

%define _unpackaged_files_terminate_build 1

%description
Mousepad is a text editor for Xfce based on Leafpad. The initial reason
for Mousepad was to provide printing support, which would have been
difficult for Leafpad for various reasons.

%description -l ru_RU.UTF-8
Mousepad - простой текстовый редактор для Xfce основанный на Leafpad.
Одной из причин разработки нового редактора было предоставление
возможности печати, что было сложно реализуемо для редактора Leafpad
по некоторым причинам.

%prep
%setup
%patch -p1

%build
%xfce4reconf
# Don't explicitly enable/disable shortcuts plugin:
# we are relly on libxfce4ui version check, so
# it will be automatically enabled with libxfce4ui-gtk3 >= 4.17.5
# (Sisyphus) and disabled otherwise (p10).
%configure \
	--enable-maintainer-mode \
	--enable-gtksourceview4 \
	--enable-plugin-gspell \
	--disable-plugin-test \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang mousepad

%files -f mousepad.lang
%doc NEWS README.md
%_bindir/*
%_libdir/*.so
%_libdir/*.so.*
%_libdir/%name/
%_datadir/polkit-1/actions/*.policy
%_datadir/glib-2.0/schemas/*.gschema.xml
%_datadir/metainfo/*.xml
%_iconsdir/hicolor/*/apps/*
%_desktopdir/*

%exclude %_libdir/%name/plugins/*.la

%changelog
