%define _unpackaged_files_terminate_build 1

%def_enable ao
%def_enable shout
%def_enable tcp
%def_enable curl
%def_disable ipv6
%def_enable fluidsynth
%def_disable wildmidi
%def_enable oss
%def_enable alsa
%def_enable jack
%def_enable pulse
%def_enable fifo
%def_enable vorbis
%def_enable flac
%def_enable mad
%def_enable vorbisenc
%def_enable lame
%def_enable audiofile
%def_enable mikmod
%def_disable modplug
%def_enable faad
%def_disable mpc
%def_disable ffmpeg
%def_enable wavpack
%def_enable id3
%def_enable lsr
%def_enable mms
%def_enable bzip2
%def_enable zip
%def_enable iso9660
%def_enable sqlite
%def_disable sidplay
%def_enable doc
%def_disable tremor
%def_enable mpg123
%def_enable nfs
%def_enable webdav
%def_enable upnp
%def_enable mpdclient
%def_enable smbclient
%def_enable opus
%def_enable systemd
# auto|avahi|bonjour|disabled
%define zeroconf avahi
%define mpd_user _mpd
%define mpd_group _mpd
#----------------------------------------------------------------------
%define subst_enable_meson_feature() %{expand:%%{?_enable_%{1}:-D%{2}=enabled}} %{expand:%%{?_disable_%{1}:-D%{2}=disabled}}
%define subst_enable_meson_bool() %{expand:%%{?_enable_%{1}:-D%{2}=true}} %{expand:%%{?_disable_%{1}:-D%{2}=false}}
%define set_disable() %{expand:%%force_disable %{1}} %{expand:%%undefine _enable_%{1}}

%if_enabled systemd
%define _userunitdir %(pkg-config systemd --variable systemduserunitdir)
%endif

%if_enabled tremor
%set_disable shout
%endif
%{!?zeroconf:%define zeroconf disabled}

%define  Name MPD

Name:    mpd
Version: 0.21.24
Release: alt1.1

Summary: Music Player Daemon (%Name) allows remote access for playing music and managing playlists
License: %gpl2plus
Group:   Sound
Url:     https://musicpd.org

# VCS:   https://github.com/MusicPlayerDaemon/MPD.git
Source:  %name-%version.tar
Source1: %name.conf
Source2: %name.sys.conf.in
Source3: %name.init.in
Source4: %name.logrotate
Source5: %name.tmpfile

Patch10: mpd-0.21.24-alt-docs-remove-upload-target.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): meson
%if_enabled systemd
BuildRequires(pre): systemd-devel /usr/bin/pkg-config
%endif
BuildRequires: zlib-devel gcc-c++
%{?_enable_curl:BuildRequires: libcurl-devel}
%{?_enable_alsa:BuildRequires: libalsa-devel >= 0.9.0}
%{?_enable_jack:BuildRequires: jackit-devel}
%{?_enable_ao:BuildRequires: libao-devel}
%{?_enable_shout:BuildRequires: libshout2-devel}
%{?_enable_audiofile:BuildRequires: libaudiofile-devel >= 0.1.7}
%{?_enable_mikmod:BuildRequires: libmikmod-devel >= 3.1.7}
%{?_enable_modplug:BuildRequires: libmmodplug-devel}
%{?_enable_faad:BuildRequires: libfaad-devel}
%{?_enable_flac:BuildRequires: libflac-devel >= 1.1.3}
%{?_enable_id3:BuildRequires: libid3tag-devel}
%{?_enable_mad:BuildRequires: libmad-devel}
%{?_enable_vorbisenc:BuildRequires: libvorbis-devel}
%{?_enable_lame:BuildRequires: liblame-devel}
%{?_enable_mpc:BuildRequires: libmpcdec-devel}
%{?_enable_ffmpeg:BuildRequires: libavformat-devel}
%{?_enable_wavpack:BuildRequires: libwavpack-devel}
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}
%{?_enable_vorbis:BuildRequires: libvorbis-devel}
%{?_enable_lsr:BuildRequires: libsamplerate-devel}
%{?_enable_mms:BuildRequires: libmms-devel >= 0.4}
%{?_enable_sidplay:BuildRequires: libsidplay2-devel}
%{?_enable_zip:BuildRequires: zziplib-devel >= 0.13}
%{?_enable_bzip2:BuildRequires: bzlib-devel}
%{?_enable_iso9660:BuildRequires: libcdio-devel}
%{?_enable_sqlite:BuildRequires: libsqlite3-devel}
%{?_enable_fluidsynth:BuildRequires: libfluidsynth-devel}
%{?_enable_mpg123:BuildRequires: libmpg123-devel}
%{?_enable_nfs:BuildRequires: libnfs-devel}
%{?_enable_webdav:BuildRequires: libcurl-devel libexpat-devel}
%{?_enable_upnp:BuildRequires: libupnp-devel}
%{?_enable_mpdclient:BuildRequires: libmpdclient-devel}
%{?_enable_smbclient:BuildRequires: libsmbclient-devel}
%{?_enable_opus:BuildRequires: libopus-devel}
%{?_enable_doc:BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink}
%if %zeroconf == avahi
BuildRequires: libavahi-glib-devel libdbus-devel
%endif

BuildRequires: boost-complete libicu-devel

%description
Music Player Daemon (%Name) allows remote access for playing music
(MP3, Ogg Vorbis, FLAC, AAC, Mod, and wave files) and managing
playlists. %Name is designed for integrating a computer into a stereo
system that provides control for music playback over a local network.
It is also makes a great desktop music player, especially if you are a
console junkie, like frontend options, or restart X often.

%if_enabled doc
%package doc
Summary: Music Player Daemon (%Name) documentation
Group: Documentation
BuildArch: noarch
Conflicts: %name < %version

%description doc
Music Player Daemon (%Name) allows remote access for playing music
(MP3, Ogg Vorbis, FLAC, AAC, Mod, and wave files) and managing
playlists. %Name is designed for integrating a computer into a stereo
system that provides control for music playback over a local network.
It is also makes a great desktop music player, especially if you are a
console junkie, like frontend options, or restart X often.
This package contains %Name documentation.
%endif

%prep
%setup
%patch10 -p1

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%meson \
	%{subst_enable_meson_feature tremor tremor} \
	%{subst_enable_meson_feature ao ao} \
	%{subst_enable_meson_feature shout shout} \
	%{subst_enable_meson_bool tcp tcp} \
	%{subst_enable_meson_feature curl curl} \
	%{subst_enable_meson_feature ipv6 ipv6} \
	%{subst_enable_meson_feature oss oss} \
	%{subst_enable_meson_feature alsa alsa} \
	%{subst_enable_meson_feature jack jack} \
	%{subst_enable_meson_feature pulse pulse} \
	%{subst_enable_meson_bool fifo fifo} \
	%{subst_enable_meson_feature vorbis vorbis} \
	%{subst_enable_meson_feature flac flac} \
	%{subst_enable_meson_feature mad mad} \
	%{subst_enable_meson_feature lame lame} \
	%{subst_enable_meson_feature vorbisenc vorbisenc} \
	%{subst_enable_meson_feature audiofile audiofile} \
	%{subst_enable_meson_feature mikmod mikmod} \
	%{subst_enable_meson_feature modplug modplug} \
	%{subst_enable_meson_feature mpc mpcdec} \
	%{subst_enable_meson_feature ffmpeg ffmpeg} \
	%{subst_enable_meson_feature wavpack wavpack} \
	%{subst_enable_meson_feature id3 id3tag} \
	%{subst_enable_meson_feature lsr libsamplerate} \
	%{subst_enable_meson_feature mms mms} \
	%{subst_enable_meson_feature sidplay sidplay} \
	%{subst_enable_meson_feature bzip2 bzip2} \
	%{subst_enable_meson_feature zip zzip} \
	%{subst_enable_meson_feature iso9660 iso9660} \
	%{subst_enable_meson_feature sqlite sqlite} \
	%{subst_enable_meson_feature fluidsynth fluidsynth} \
	%{subst_enable_meson_feature wildmidi wildmidi} \
	%{subst_enable_meson_feature mpg123 mpg123} \
	%{subst_enable_meson_feature nfs nfs} \
	%{subst_enable_meson_feature webdav webdav} \
	%{subst_enable_meson_feature upnp upnp} \
	%{subst_enable_meson_feature mpdclient libmpdclient} \
	%{subst_enable_meson_feature smbclient smbclient} \
	%{subst_enable_meson_feature opus opus} \
	%{subst_enable_meson_bool doc documentation} \
	%{subst_enable_meson_feature systemd systemd} \
%if_enabled systemd
	-Dsystemd_system_unit_dir=%_unitdir \
	-Dsystemd_user_unit_dir=%_userunitdir \
%endif
	-Dzeroconf=%zeroconf \
	%nil

%meson_build

%install
%meson_install

install -d %buildroot{%_localstatedir/%name/playlists,{%_runtimedir,%_logdir}/%name,%_sysconfdir,%_initdir,%_tmpfilesdir}
sed -e "s|@localstatedir@|%_localstatedir|g" -e "s|@logdir@|%_logdir|g" %SOURCE1 > %buildroot%_sysconfdir/%name.conf
chmod 644 %buildroot%_sysconfdir/%name.conf
sed 's/@MPD_USER@/%mpd_user/g' %SOURCE2 > %buildroot%_sysconfdir/%name.sys.conf
chmod 640 %buildroot%_sysconfdir/%name.sys.conf
sed 's/@MPD_USER@/%mpd_user/g' %SOURCE3 > %buildroot%_initdir/%name
chmod 755 %buildroot%_initdir/%name
sed 's/@MPD_USER@/%mpd_user/g' %SOURCE5 > %buildroot%_tmpfilesdir/%name.conf
chmod 644 %buildroot%_tmpfilesdir/%name.conf
install -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/logrotate.d/%name

%pre
%_sbindir/groupadd -r -f %mpd_group &>/dev/null ||:
%_sbindir/useradd -r -n -M -s /dev/null -d %_localstatedir/%name -g %mpd_group \
    -c "Music Player Daemon (%Name)" %mpd_user &>/dev/null ||:
%_sbindir/usermod -g %mpd_group -G audio %mpd_user &>/dev/null ||:

%post
%post_service %name ||:

%preun
%preun_service %name ||:

%files
%if_disabled doc
%_defaultdocdir/%name
%endif
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/%name.sys.conf
%config(noreplace) %_sysconfdir/logrotate.d/*
%_bindir/*
%if_enabled doc
%_man1dir/*
%_man5dir/*
%endif
%_initdir/*
%if_enabled systemd
%_unitdir/*
%_userunitdir/*
%endif
%_tmpfilesdir/*
%attr(775,root,%mpd_group) %dir %_localstatedir/%name
%attr(775,root,%mpd_group) %dir %_localstatedir/%name/playlists
%attr(775,root,%mpd_group) %dir %_logdir/%name
%_iconsdir/hicolor/scalable/apps/%name.svg

%if_enabled doc
%files doc
%_defaultdocdir/%name
%endif

%changelog
