%def_without floppyd

Name: mtools
Version: 4.0.32
Release: alt3
Epoch: 1

Summary: Programs for accessing FAT formatted media without mounting it
License: GPLv3
Group: File tools

Url: http://www.gnu.org/software/mtools/intro.html
Source0: %url/%{name}-%{version}.tar.gz
Source1: floppyd.xinetd
Source100: mtools.watch
Packager: Michael Shigorin <mike@altlinux.org>

Patch0: mtools-3.9.6-config.patch
Patch2: mtools-3.9.6-atari.patch
Patch3: mtools-3.9.7-texinfo.patch
Patch4: mtools-3.9.10-alt-no-x.patch
Patch5: mtools-4.0.10-alt-buffer.patch

# for check
BuildRequires: dosfstools

Requires: glibc-gconv-modules

%if_with floppyd
# Automatically added by buildreq on Tue Apr 07 2009 (-bi)
BuildRequires: imake libSM-devel libX11-devel libXau-devel xorg-cf-files
%endif

%define inetd_dir     %_sysconfdir/xinetd.d
%define inetd_floppyd %inetd_dir/floppyd

Summary(ru_RU.UTF-8): Утилиты для работы с дисками MS-DOS
# explicitly added texinfo for info files
BuildRequires: texinfo

%package floppyd
Group: File tools
Requires: xinetd
Summary: Daemon for remote access to floppy drive
Summary(ru_RU.UTF-8): Демон для доступа к дисководам через сеть и X-терминал

%description
Mtools is a collection of utilities for accessing MS-DOS files.
Mtools allow you to read, write and move around MS-DOS filesystem
files (normally on MS-DOS floppy disks).  Mtools supports Windows95
style long file names, OS/2 Xdf disks, and 2m disks.

Mtools should be installed if you need to use MS-DOS disks without
mounting them.

%description -l ru_RU.UTF-8
Mtools содержит набор утилит для работы с дисками MS-DOS:
форматирования, чтения/записи, управления атрибутами,
проверки на сбойные блоки и т.д.

Mtools работает с дискетами напрямую, минуя драйверы файловых систем Линукса,
то есть монтировать дискету утилитой mount при использовании Mtools не нужно.
Это означает, что поддержка FAT в ядре операционной системы не требуется
(хотя её отсутствие сейчас - случай уникальный).

Mtools поддерживает длинные имена в стиле Windows95, Xdf-диски OS/2,
а также дискеты большой ёмкости, созданные с помощью утилиты 2m.

%description floppyd
Floppyd is used as a server to grant access to the floppy drive to clients
running on a remote machine, just as an X server grants access to the display
to remote clients. floppyd is always associated with an X server.
It runs on the same machine as its X server, and listens on port 5703 and above.

%description floppyd -l ru_RU.UTF-8
Floppyd является сервером, предоставляющим доступ к дискетам для клиентов,
работающих на других компьютерах подобно тому, как X-сервер предоставляет им
доступ к монитору. Floppyd выполняет привязку к X-серверу, запущенному
на том же компьютере, и пользуется его системой авторизации.

%prep
%setup
%patch0 -p1
#patch2 -p1
#patch3 -p1
%if_without floppyd
#patch4 -p1
%endif
#patch5 -p1

find -type f -print0 |
	xargs -r0 grep -FZl -- /usr/local/etc |
	xargs -r0 sed -i -- 's,/usr/local/etc,%_sysconfdir,g'

%build
%autoreconf
%configure
%make_build all info

%install
%makeinstall install-info
install -pDm644 %name.conf %buildroot%_sysconfdir/%name.conf

%if_with floppyd
mkdir -p %buildroot%_sbindir
mv %buildroot%_bindir/floppyd* %buildroot%_sbindir
install -pD %SOURCE1 %buildroot%inetd_floppyd
%else
find %buildroot -name floppyd\* -print0 | xargs -r0 rm -fv --
%endif

%check
dd if=/dev/zero of=.efiboot.img bs=32k count=227
/sbin/mkfs.fat -v -n 'El Torito' .efiboot.img
mkdir -p EFI/BOOT EFI/enroll
touch EFI/BOOT/bootia32.efi EFI/enroll/cert
%buildroot%_bindir/mcopy -v -i .efiboot.img -s EFI ::

%files
%config(noreplace) %_sysconfdir/%name.conf
%_bindir/*
%_mandir/man?/*
%_infodir/*.info*
%doc NEWS README mkdosboot *.tex

%if_with floppyd

%exclude %_man1dir/floppyd*

%files floppyd
%inetd_floppyd
%_sbindir/floppyd*
%_man1dir/floppyd*

%endif

# TODO:
# - revisit mtools-3.9.10-alt-no-x.patch?
# - review, rediff and send upstream patch1, patch2

%changelog
