%define _unpackaged_files_terminate_build 1
%def_enable libdmmp

%define syslibdir /%_lib
%define libmpathdir %syslibdir/multipath

Name: multipath-tools
Version: 0.9.3
Release: alt2

Summary: Tools to manage multipath devices with device-mapper
License: GPL-2.0-only
Group: System/Configuration/Hardware

Url: http://christophe.varoqui.free.fr
Vcs: https://github.com/opensvc/multipath-tools.git
Source: %name-%version.tar
Source2: multipath.rules
Source3: multipathd.init
Source4: multipath.modules
Source5: multipath.conf
Patch1: %name-%version.patch

Provides: device-mapper-multipath = %EVR

Requires: libmultipath = %EVR
Requires: kpartx = %EVR
Requires: dmsetup
Requires: udev-rules-sgutils sg3_utils

BuildRequires: libaio-devel libdevmapper-devel libreadline-devel libudev-devel libsystemd-devel
BuildRequires: libuserspace-rcu-devel
%{?_enable_libdmmp:BuildRequires: libjson-c-devel}

%description
This package provides the tools to manage multipath devices by
instructing the device-mapper multipath module what to do.
The tools are:
- multipath: lists and configures multipath devices.
- multipathd: monitors paths; as paths fail and come back, it may
  initiate path group switches.

%package -n libmultipath
Summary: The %name modules and shared library
License: GPL-2.0-only AND LGPL-2.1-only AND LGPL-2.0-or-later
Group: System/Libraries
Conflicts: multipath-tools <= 0.4.9-alt3

%description -n libmultipath
The libmultipath provides the path checker
and prioritizer modules. It also contains the multipath shared library,
libmultipath.

%package -n libmultipath-devel
Summary: Development libraries and headers for %name
Group: Development/C
License: GPL-2.0-only AND LGPL-2.0-or-later
Requires: libmultipath = %EVR

%description -n libmultipath-devel
This package contains the files need to develop applications that use
multipath-tools's libmpathpersist and libmpathcmd libraries.

%package -n kpartx
Summary: Partition device manager for device-mapper devices
Group: System/Configuration/Hardware
License: GPL-2.0-only
Conflicts: multipath-tools <= 0.4.9-alt3

%description -n kpartx
kpartx manages partition creation and removal for device-mapper devices.

%package -n libdmmp
Summary: multipath-tools C API library
Group: System/Libraries
License: GPL-3.0-or-later

%description -n libdmmp
This package contains the shared library for the multipath-tools
C API library.

%package -n libdmmp-devel
Summary: device-mapper-multipath C API library headers
Group: Development/C
License: GPL-3.0-or-later
Requires: libdmmp = %EVR

%description -n libdmmp-devel
This package contains the files needed to develop applications that use
device-mapper-multipath's libdmmp C API library

%prep
%setup -q
%patch1 -p1
%ifarch %e2k
sed -i "s|-Werror -Wall|-Wall|" Makefile.inc
%endif

%build
unset RPM_OPT_FLAGS
%make_build \
	prefix=%_prefix \
	libdir=%libmpathdir \
	plugindir=%libmpathdir \
    configdir=%_sysconfdir/multipath/conf.d \
	LIB=%_lib \
	RUN=run \
	%{?_disable_libdmmp: ENABLE_LIBDMMP=0} \
	SYSTEMDPATH=lib \
    EXTRAVERSION=%release

%install
mkdir -p %buildroot{/sbin,%_libdir,%_man8dir,%_initdir,%_unitdir,%_udevrulesdir,%_modulesloaddir,%_sysconfdir/multipath}
%makeinstall_std \
	prefix=%_prefix \
	DESTDIR=%buildroot \
	SYSTEMDPATH=lib \
	%{?_disable_libdmmp: ENABLE_LIBDMMP=0} \
	LIB=%_lib \
	RUN=run \
	bindir=/sbin \
	syslibdir=%syslibdir \
	libdir=%libmpathdir \
	plugindir=%libmpathdir \
	usr_prefix=%_prefix \
    configdir=%_sysconfdir/multipath/conf.d \
	rcdir=%_initrddir \
	udevrulesdir=%_udevrulesdir \
	unitdir=%_unitdir \
	libudevdir=/lib/udev \
	tmpfilesdir=%_tmpfilesdir \
	modulesloaddir=%_modulesloaddir \
    EXTRAVERSION=%release

install -pm755 %SOURCE3 %buildroot%_initdir/multipathd
install -pm644 %SOURCE5 %buildroot%_sysconfdir/multipath.conf

%post
%post_service multipathd

%preun
%preun_service multipathd

%files
%doc README.md
/sbin/multipath
/sbin/multipathd
#/sbin/mpathconf
/sbin/mpathpersist
/sbin/multipathc
%_udevrulesdir/*
%exclude %_udevrulesdir/*kpartx.rules
%_modulesloaddir/*
%dir %_sysconfdir/multipath
%config(noreplace) %attr(644,root,root) %_sysconfdir/multipath.conf
%_initdir/*
%_unitdir/*
%_tmpfilesdir/*
%_man5dir/*
%_man8dir/*
%exclude %_man8dir/kpartx.8.*

%files -n libmultipath
/%_lib/libmultipath.so.*
/%_lib/libmpathcmd.so.*
/%_lib/libmpathpersist.so.*
/%_lib/libmpathvalid.so.*
/%_lib/libmpathutil.so.*
%dir %libmpathdir
%libmpathdir/*

%files -n libmultipath-devel
/%_lib/libmultipath.so
/%_lib/libmpathpersist.so
/%_lib/libmpathcmd.so
/%_lib/libmpathvalid.so
/%_lib/libmpathutil.so
%_includedir/mpath_cmd.h
%_includedir/mpath_persist.h
%_includedir/mpath_valid.h
%_man3dir/mpath_*

%files -n kpartx
%_udevrulesdir/*kpartx.rules
/sbin/kpartx
/lib/udev/kpartx_id
%_man8dir/kpartx.8.*

%files -n libdmmp
%_libdir/libdmmp.so.*

%files -n libdmmp-devel
%_libdir/libdmmp.so
%dir %_includedir/libdmmp
%_includedir/libdmmp/*
%_man3dir/dmmp_*
%_man3dir/libdmmp.h.3.*
%_pkgconfigdir/libdmmp.pc

%changelog
