%define soname 25
Name: mupdf
Version: 1.25.2
Release: alt1
Summary:  MuPDF is a lightweight open source software framework for viewing and converting PDF, XPS, and E-book documents.
Group: Office
URL: https://github.com/ArtifexSoftware/mupdf
License: AGPL-3.0

Source:  %name-%version.tar
Source1: %name-%version-thirdparty-extract.tar
Source2: %name-%version-thirdparty-lcms2.tar
Source3: %name-%version-thirdparty-mujs.tar

Patch0: disable_strip.patch

BuildRequires: make gcc-c++
BuildRequires: zlib-devel libopenjpeg2.0-devel libjbig2dec-devel libgumbo-devel
BuildRequires: libfreeglut-devel libfreetype-devel libharfbuzz-devel gdcm-devel libjpeg-devel
BuildRequires: libX11-devel libXext-devel

Requires: lib%name%soname = %EVR

%package -n lib%name%soname
Summary: MuPDF library for PDF render
Group: System/Libraries

%package -n lib%name-devel
Summary: Development files for MuPDF library
Group: Development/C
Requires: lib%name%soname = %EVR

%description
MuPDF is a lightweight open source software framework for viewing and converting PDF, XPS, and E-book documents.
%description -n lib%name%soname
MuPDF shared library
%description -n lib%name-devel
Header files for the MuPDF shared library

%prep
%setup -a1 -a2 -a3
%patch0 -p1

%build

%make_build shared-release USE_SYSTEM_LIBS=yes  FZ_ENABLE_PDF=1 \
	XCFLAGS="-I/usr/include/freetype2/ -I/usr/include/harfbuzz/ \
	-I/usr/include/gdcm/gdcmjpeg/ -I/usr/include/gdcm/gdcmjpeg/8/ \
	-I/usr/include/openjpeg-2.5/" \
	XLDFLAGS="-g -L/usr/lib64"  XLIBS="-lgdcmjpeg8" --trace

%install
#%%define _makeinstall_target install-shared-c install-apps install-docs
make INSTALL="/bin/install -p" \
	 USE_SYSTEM_LIBS=yes \
	 DESTDIR=%buildroot \
	 bindir=%_bindir \
	 libdir=%_libdir \
	 incdir=%_includedir \
	 mandir=%_mandir \
	 prefix=%_prefix \
	 install-shared-c install-apps install-docs

%files
%_bindir/mupdf-gl
%_bindir/mupdf-x11
%_bindir/muraster
%_bindir/mutool
%_mandir/man1/*

%files -n lib%name%soname
%_libdir/libmupdf.so.%{soname}*
%doc %_defaultdocdir/%name/CHANGES
%doc %_defaultdocdir/%name/COPYING
%doc %_defaultdocdir/%name/README

%files -n lib%name-devel
%_includedir/mupdf/*.h
%_includedir/mupdf/fitz/*.h
%_includedir/mupdf/pdf/*.h

%_libdir/libmupdf.so
%doc %_defaultdocdir/%name/examples/*

%changelog
