%define rname mscore
%define mversion 3.6

Name: musescore
Version: %mversion.2
Release: alt1

Summary: Music notation and composition software

License: GPLv2
Group: Sound
Url: https://musescore.org

# https://github.com/musescore/MuseScore
Source: %name-%version.tar

BuildPreReq: chrpath rpm-build-xdg

# Automatically added by buildreq on Thu Jan 06 2011
BuildRequires: ccmake doxygen gcc-c++ ghostscript-utils graphviz latex2html
BuildRequires: libalsa-devel libjack-devel libportaudio2-devel libsndfile-devel
BuildRequires: qt5-designer qt5-base-devel libpulseaudio-devel libfreetype-devel
BuildRequires: liblame-devel qt5-tools-devel qt5-webkit-devel qt5-declarative-devel
BuildRequires: qt5-script-devel qt5-xmlpatterns-devel qt5-quick1-devel qt5-svg-devel
BuildRequires: qt5-tools-devel-static zlib-devel libvorbis-devel libportmidi-devel
BuildRequires: qt5-webengine-devel qt5-quickcontrols2-devel

%description
Music notation and composition software

* WYSIWYG design, notes are entered on a "virtual notepaper"
* TrueType font(s) for printing & display allows for high quality scaling to all sizes
* easy & fast note entry
* many editing functions
* MusicXML import/export
* Midi (SMF) import/export
* MuseData import
* Midi input for note entry
* integrated sequencer and software synthesizer to play the score
* print or create pdf files

%prep
%setup

# Remove -lporttime on RPM-based systems where PortTime is part of PortMidi
sed -i 's/ -lporttime//' mscore/CMakeLists.txt

%build
export PATH=$PATH:%_qt5_bindir
echo $PATH
mkdir build.debug && cd build.debug
cmake \
    -DCMAKE_BUILD_TYPE=RELEASE \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
    -DBUILD_SCRIPTGEN=FALSE \
    -DUSE_SYSTEM_FREETYPE=ON \
    -DBUILD_WEBENGINE=OFF \
    ..

make lrelease
make manpages
make mops1 mops2
%make_build

%install
cd build.debug
%makeinstall_std
for f in ../fonts/*.ttf ../fonts/*.xml; do
     install -D $f %buildroot%_datadir/mscore-%mversion/fonts/$(basename $f)
done
for f in ../fonts/bravura/*.otf ../fonts/bravura/*.json; do
     install -D $f %buildroot%_datadir/mscore-%mversion/fonts/bravura/$(basename $f)
done
for f in ../fonts/gootville/*.otf ../fonts/gootville/*.json; do
     install -D $f %buildroot%_datadir/mscore-%mversion/fonts/gootville/$(basename $f)
done
for f in ../fonts/mscore/*.ttf  ../fonts/mscore/*.json; do
     install -D $f %buildroot%_datadir/mscore-%mversion/fonts/mscore/$(basename $f)
done

chrpath -d %buildroot%_bindir/mscore

%files
%_bindir/*
%_datadir/metainfo/org.musescore.MuseScore.appdata.xml
%_desktopdir/mscore.desktop
%_datadir/mscore-%mversion
%_man1dir/*
%_xdgmimedir/packages/musescore.xml
%_iconsdir/hicolor/16x16/apps/mscore.png
%_iconsdir/hicolor/32x32/apps/mscore.png
%_iconsdir/hicolor/48x48/apps/mscore.png

%changelog
