Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Summary:       Official JDBC driver for MySQL
Name:          mysql-connector-java
Version:       8.0.25
Release:       alt1_2jpp11
Epoch:         1
License:       GPLv2 with exceptions
URL:           http://dev.mysql.com/downloads/connector/j/
Source0:       %{name}-%{version}-nojars.tar.xz

# Mysql has a mirror redirector for its downloads
# You can get this tarball by following a link from:
# http://dev.mysql.com/get/Downloads/Connector-J/%%{name}-%%{version}.tar.gz
#
# OR
# https://github.com/mysql/mysql-connector-j/archive/%%{version}.tar.gz
# Following prebuilt jars and sources have been removed from the tarball:
#
# %%{name}-%%{version}-bin.jar
# lib/c3p0-0.9.1-pre6.jar
# lib/c3p0-0.9.1-pre6.src.zip
# lib/jboss-common-jdbc-wrapper.jar
# lib/jboss-common-jdbc-wrapper-src.jar
# lib/protobuf-java-3.6.1.jar
# lib/slf4j-api-1.6.1.jar
#
# See http://bugs.mysql.com/bug.php?id=28512 for details.

# To make it easier a script generate-tarball.sh has been created:
# ./generate-tarball.sh version
# will create a new tarball compressed with xz and without those jar files.
Source1:       generate-tarball.sh

Patch1:        remove-coverage-test.patch

BuildArch:     noarch

BuildRequires: ant >= 1.6.0
BuildRequires: ant-junit
BuildRequires: apache-commons-logging
BuildRequires: git
BuildRequires: javassist
BuildRequires: javapackages-local
BuildRequires: junit5
BuildRequires: protobuf-java
BuildRequires: slf4j
BuildRequires: java-1.8.0-openjdk-devel

Requires:      slf4j
Requires: java
Source44: import.info

%description
MySQL Connector/J is a native Java driver that converts JDBC (Java Database
Connectivity) calls into the network protocol used by the MySQL database.
It lets developers working with the Java programming language easily build
programs and applets that interact with MySQL and connect all corporate
data, even in a heterogeneous environment. MySQL Connector/J is a Type
IV JDBC driver and has a complete JDBC feature set that supports the
capabilities of MySQL.

%prep
%setup -q -n mysql-connector-j-%{version}

# fix line endings
for file in README README.md; do
 sed -i.orig 's|\r||g' $file
 touch -r $file.orig $file
 rm $file.orig
done

sed -i 's/>@.*</>%{version}</' src/build/misc/pom.xml

%patch1 -p1

%build

# We need both JDK1.5 (for JDBC3.0; appointed by $JAVA_HOME) and JDK1.6 (for JDBC4.0; appointed in the build.xml)
export CLASSPATH=$(build-classpath jdbc-stdext junit slf4j commons-logging.jar)

# We currently need to disable jboss integration because of missing jboss-common-jdbc-wrapper.jar (built from sources).
# See BZ#480154 and BZ#471915 for details.
rm -rf src/main/user-impl/java/com/mysql/cj/jdbc/integration/jboss
rm src/test/java/testsuite/regression/ConnectionRegressionTest.java
rm src/test/java/testsuite/regression/DataSourceRegressionTest.java
rm src/test/java/testsuite/simple/StatementsTest.java

ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -Dcom.mysql.cj.build.jdk=/usr/lib/jvm/java-1.8.0-openjdk \
    -Dcom.mysql.cj.extra.libs=%{_javadir} \
    test dist

%install
# Install the Maven build information
%mvn_file mysql:mysql-connector-java %{name}
%mvn_artifact src/build/misc/pom.xml build/%{name}-%{version}-SNAPSHOT/%{name}-%{version}-SNAPSHOT.jar
%mvn_install

%files -f .mfiles
%doc CHANGES README README.md
%doc --no-dereference LICENSE

%changelog
