# TODO: there is exist driver registration utility, add some macros?
# odbcinst -i -d -f template

Name: mysql-connector-odbc
Version: 8.0.36
Release: alt1

Summary: MySQL Connector/ODBC - ODBC driver for MySQL

# exceptions allow library to be linked with most open source SW,
# not only GPL code.
License: %gpl2only
Group: System/Libraries
Url: https://github.com/mysql/mysql-connector-odbc
# https://dev.mysql.com/doc/connector-odbc/en/

Source0: %name-%version.tar
Patch0:  %name-%version-%release.patch

Source1: odbc.ini
Source2: odbcinst.ini

Patch1: %name-8.0.22-alt-rpath.patch
Patch2: %name-8.0.13-fedora-myodbc-64bit.patch
Patch3: %name-8.0.35-libdir-wtf.patch

BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Wed Aug 08 2018
# optimized out: cmake-modules glibc-kernheaders-generic glibc-kernheaders-x86 libcrypt-devel libncurses-devel libstdc++-devel libtinfo-devel libunixODBC-devel-compat python-base python-modules python3 python3-base python3-dev ruby
BuildRequires: cmake gcc-c++ glibc-devel-static libmysqlclient21-devel libsasl2-devel libssl-devel libunixODBC-devel

%description
MySQL Connector/ODBC   allows you to connect to MySQL database
servers using ODBC, the Open Database Connectivity abstraction
layer which is understood by a variety of database tools that
cannot talk to MySQL databases directly.

Connector/ODBC documentation for detailed installation and
setup instructions can be found at 
  https://dev.mysql.com/doc/connector-odbc/en/


%prep
%setup
%patch0 -p1

%patch1 -p2
%patch2 -p1
%patch3 -p1

%build
%cmake -G "Unix Makefiles" \
    -DCMAKE_BUILD_TYPE=RelWithDebinfo \
    -DWITH_UNIXODBC=1 \
    -DMYSQLCLIENT_STATIC_LINKING=false \
    -DBUNDLE_DEPENDENCIES=false \
    -DHAVE_STRUCT_TIMESPEC=1 \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DDISABLE_GUI=1 \
    -DRPM_BUILD=1 \
    ..

%cmake_build

%install
%cmakeinstall_std

%ifarch %e2k
# no LIB_SUFFIX reaction
mkdir -p %buildroot%_libdir
mv %buildroot{%_prefix/lib/*,%_libdir} ||:
%endif

install -pm 0644 %SOURCE1 odbc.ini
install -pm 0644 %SOURCE2 odbcinst.ini
sed -e 's#@@lib@@#%_libdir#g' -i odbcinst.ini

rm -f %buildroot/%_prefix/{ChangeLog,README.txt,LICENSE.txt,INFO_BIN,INFO_SRC}

%files
%doc ChangeLog README.txt LICENSE.txt odbcinst.ini odbc.ini INFO_BIN INFO_SRC
%_bindir/myodbc-installer
%_libdir/libmyodbc*
%exclude %_prefix/test

%changelog
