# build judy
# wait for or drop armh: https://bugzilla.altlinux.org/show_bug.cgi?id=39152
# TODO: pyyaml3, urllib3
# TODO: use cmake?

%def_disable cloud
%def_with prometeus
%def_without nfacct
%def_without pyod

# Please, update here commit id for the release
%define release_commit 9dc3b13b4d0f372d32f83788b2acce7060362a14

%define netdatauser netdata
Name: netdata
Version: 1.43.2
Release: alt2

Summary: Real-time performance monitoring, done right!

License: GPLv3+
Group: Monitoring
Url: http://netdata.firehol.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/netdata/netdata/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

Source1: netdata.logrotate

BuildRequires(pre): rpm-build-python3
BuildRequires: bash4
BuildRequires: libuuid-devel libuv-devel libprotobuf-devel
BuildRequires: libjudy-devel libcap-devel
BuildRequires: liblz4-devel zlib-devel libssl-devel
BuildRequires: libjson-c-devel libyaml-devel

%if_with prometeus
# Prometheus remote write dependencies
BuildRequires: libsnappy-devel
BuildRequires: libprotobuf-devel
%endif


BuildRequires: libcups-devel >= 1.7

Requires: bash4

BuildRequires: rpm-macros-intro-conflicts
BuildRequires: rpm-build-intro >= 2.1.1

%if_with nfacct
BuildRequires: libmnl-devel
BuildRequires: libnetfilter_acct-devel
%endif

%if_enabled cloud
BuildRequires: libwebsockets-devel >= 3.2.2
BuildRequires: libmosquitto-devel >= 1.6.8
%endif

BuildRequires: gcc-c++

Requires: %name-web = %EVR

AutoReq: yes, noshell

%add_python3_lib_path %_libexecdir/%name/python.d

#add_findreq_skiplist %_libexecdir/%name/plugins.d/*.plugin
%add_findreq_skiplist %_libexecdir/%name/charts.d/*.sh

%add_python3_req_skip UserDict

# make optionally (wait for asks)
%add_python3_req_skip pandas netdata_pandas netdata_pandas.data
# make optionally (reqs numpy)
%add_python3_req_skip changefinder


# FIXME netdata-postgres
#python3(python_modules.bases.FrameworkServices.ExecutableService)
%add_python3_req_skip bases.FrameworkServices.SimpleService

# python.d/python_modules/pyyaml3/__init__.py: invalid syntax (line 284)
#add_findreq_skiplist %_libexecdir/%name/python.d/python_modules/*/*.py
#if %_vendor != "alt"
#global __python %__python3
#endif

%description
netdata is the fastest way to visualize metrics. It is a resource
efficient, highly optimized system for collecting and visualizing any
type of realtime timeseries data, from CPU usage, disk activity, SQL
queries, API calls, web site visitors, etc.

netdata tries to visualize the truth of now, in its greatest detail,
so that you can get insights of what is happening now and what just
happened, on your systems and applications.

%package postgres
Summary: PostgreSQL module for %name
Group: Monitoring
Requires: %name = %EVR
#Provides: %name-postgres
#Obsoletes: %name-postgres

%description postgres
PostgreSQL module for %name.

%package web
Summary:  %name web static files
Group: Monitoring
Requires: %name = %EVR
BuildArch: noarch

%description web
%name web static files.

%package plugin-cups
Summary: The Common Unix Printing System (CUPS) plugin for netdata
Group: Monitoring
Requires: cups >= 1.7
Requires: netdata = %EVR

%description plugin-cups
This is the Common Unix Printing System plugin for the netdata daemon.

Use this plugin to enable metrics collection from cupsd, the daemon running when CUPS is enabled on the system

%prep
%setup

%if_enabled cloud
# strange upstream wants static libs
# checking if libmosquitto static lib is present (and builds)... no
# checking if libwebsockets static lib is present... no

subst 's|test -f "externaldeps|test -n "externaldeps|' configure.ac
find -type f | xargs subst "s|externaldeps/mosquitto/libmosquitto.a|-lmosquitto|"
find -type f | xargs subst "s|externaldeps/mosquitto/mosquitto.h|mosquitto.h|"

find -type f | xargs subst "s|externaldeps/libwebsockets/libwebsockets.a|-lwebsockets|"
find -type f | xargs subst "s|externaldeps/libwebsockets/include|%_includedir|"
%endif

# https://bugzilla.altlinux.org/show_bug.cgi?id=32663
%if %_vendor == "alt"
for i in plugins.d/*.plugin plugins.d/*.sh charts.d/*.sh ; do
	test -s "$i" || continue
	%__subst "s|^#!/usr/bin/env bash$|#!/bin/bash4|g" "$i"
	%__subst "s|^#!/bin/bash$|#!/bin/bash4|g" "$i"
done
%endif

# TODO: fix in the upstream
%__subst "s|^#!/usr/bin/env python$|#!/usr/bin/env python3|" collectors/python.d.plugin/python_modules/third_party/boinc_client.py

%__subst "s|^pybinary=.*|pybinary=python3|" collectors/python.d.plugin/python.d.plugin.in

%__subst 's|${libdir}/netdata/conf.d|${libexecdir}/netdata/conf.d|' configure.ac

%build
%autoreconf
%configure \
	--docdir=%_docdir/%name-%version \
	--with-zlib \
	--with-math \
	--enable-jsonc \
	--disable-h2o \
	%{subst_enable cloud} \
	%{?with_nfacct:--enable-plugin-nfacct} \
	--with-user=netdata \
	--disable-dependency-tracking

# TODO
#%ifarch i586 x86_64
#        --enable-plugin-freeipmi \
#%endif

%make_build

%install
%makeinstall_std

# drop python2 version
rm -rf %buildroot%_libexecdir/netdata/python.d/python_modules/pyyaml2/
# drop bundled urllib3
rm -rf %buildroot%_libexecdir/netdata/python.d/python_modules/urllib3/

mkdir -p %buildroot%_sysconfdir/%name/
install -m 644 -p system/netdata.conf %buildroot%_sysconfdir/%name/netdata.conf

# This should be opt-in, not opt-out. I do not believe most users would agree
# with sending usage data to Google Analytics, whether anonymized or not.
# Hence, disable statistics by default.
touch %buildroot%_sysconfdir/%name/.opt-out-from-anonymous-statistics

#mkdir -p %buildroot%_sysconfdir/%name/charts.d/

mkdir -p %buildroot%_logrotatedir/
%if %_vendor == "alt"
install -m 644 -p %SOURCE1 %buildroot%_logrotatedir/%name
%else
install -m 644 -p system/netdata.logrotate %buildroot%_logrotatedir/%name
%endif

#find %buildroot -name .keep | xargs rm

# ###########################################################
# Install cache and log directories
install -m 755 -d %buildroot/var/cache/%name/
install -m 755 -d %buildroot/var/log/%name/

# ###########################################################
# Install registry directory
install -m 755 -d %buildroot/var/lib/%name/registry/


install -d %buildroot%_unitdir/
install -m 644 -p system/systemd/netdata.service.v235 %buildroot%_unitdir/netdata.service

rm -v %buildroot/usr/lib/netdata/install-service.sh
rm -rv %buildroot%_libdir/netdata/system/

# /run vs /var/run workaround
#__subst "s|/run/netdata/netdata.pid|%_runtimedir/netdata/netdata.pid|" %buildroot%_unitdir/netdata.service

# fill with original commit id for %version release
echo "%release_commit" > %buildroot%_datadir/%name/web/version.txt

%pre
# TODO
#groupadd %netdatauser
#useradd %netdatauser -g %netdatauser -c netdata -s /sbin/nologin -d /
getent group %netdatauser >/dev/null || groupadd -r %netdatauser
getent passwd %netdatauser >/dev/null || useradd -r -g %netdatauser -c "%netdatauser user" -s /sbin/nologin -d / %netdatauser

%post
%post_service %name

%preun
%preun_service %name

%files
%doc README.md LICENSE REDISTRIBUTED.md
%attr(0700,%netdatauser,%netdatauser) %dir %_cachedir/%name/
%attr(0770,root,%netdatauser) %dir %_logdir/%name/
%attr(0700,%netdatauser,%netdatauser) %dir %_sharedstatedir/%name/
%attr(0700,%netdatauser,%netdatauser) %dir %_sharedstatedir/%name/registry/
%dir %_sysconfdir/%name/
%_sysconfdir/%name/.opt-out-from-anonymous-statistics
%_sysconfdir/%name/.install-type
%_sysconfdir/%name/edit-config
#config(noreplace) %_sysconfdir/%name/netdata.conf
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/*.conf
#dir %_sysconfdir/%name/node.d/
#config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/node.d/*
%dir %_sysconfdir/%name/health.d/
#config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/health.d/*.conf
%dir %_sysconfdir/%name/python.d/
#config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/python.d/*.conf
#dir %_sysconfdir/%name/charts.d/
#config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/statsd.d/*.conf
%dir %_sysconfdir/%name/statsd.d/
#config(noreplace) %verify(not md5 mtime size) %_sysconfdir/%name/charts.d/*.conf
%config(noreplace) %_logrotatedir/%name
%_sbindir/%name
%_sbindir/netdatacli
%_sbindir/netdata-claim.sh
%_unitdir/netdata.service
%dir %_libexecdir/%name/
%_libexecdir/%name/conf.d/
%_libexecdir/%name/charts.d/
#_libexecdir/%name/node.d/
%_libexecdir/%name/plugins.d/
%_libexecdir/%name/python.d/
%dir %_datadir/%name

#exclude %_libexecdir/%name/python.d/postgres.chart.py
%exclude %_libexecdir/%name/plugins.d/cups.plugin
%exclude %_libexecdir/%name/python.d/anomalies.chart.py
%exclude %_libexecdir/%name/python.d/__pycache__/anomalies.*

%files web
# override defattr for web files (see netdata.conf for web access user/group)
%defattr(644,root,%netdatauser,755)
%_datadir/%name/web/

#files postgres
#attr(0750,root,%netdatauser) %_libexecdir/%name/python.d/postgres.chart.py

%if_with pyod
%files plugin-anomalies
%attr(0750,root,%netdatauser) %_libexecdir/%name/python.d/anomalies.chart.py
%_libexecdir/%name/python.d/__pycache__/anomalies.*
%endif

%files plugin-cups
%attr(0750,root,%netdatauser) %_libexecdir/%name/plugins.d/cups.plugin


%changelog
